@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.DeviceArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.enums.DeviceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Device resource.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2020-01-01-preview.
 * ## Example Usage
 * ### Create or update device
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var device = new AzureNative.HybridNetwork.Device("device", new()
 *     {
 *         DeviceName = "TestDevice",
 *         DeviceType = AzureNative.HybridNetwork.DeviceType.AzureStackEdge,
 *         Location = "eastus",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewDevice(ctx, "device", &hybridnetwork.DeviceArgs{
 * 			DeviceName:        pulumi.String("TestDevice"),
 * 			DeviceType:        pulumi.String(hybridnetwork.DeviceTypeAzureStackEdge),
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.Device;
 * import com.pulumi.azurenative.hybridnetwork.DeviceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var device = new Device("device", DeviceArgs.builder()
 *             .deviceName("TestDevice")
 *             .deviceType("AzureStackEdge")
 *             .location("eastus")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:Device TestDevice /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/devices/{deviceName}
 * ```
 * @property deviceName Resource name for the device resource.
 * @property deviceType The type of the device.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class DeviceArgs(
    public val deviceName: Output<String>? = null,
    public val deviceType: Output<Either<String, DeviceType>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.DeviceArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.DeviceArgs =
        com.pulumi.azurenative.hybridnetwork.DeviceArgs.builder()
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .deviceType(
                deviceType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DeviceArgs].
 */
@PulumiTagMarker
public class DeviceArgsBuilder internal constructor() {
    private var deviceName: Output<String>? = null

    private var deviceType: Output<Either<String, DeviceType>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Resource name for the device resource.
     */
    @JvmName("krtmcyhtwscmmuhn")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value The type of the device.
     */
    @JvmName("bnsynpwfyyogohom")
    public suspend fun deviceType(`value`: Output<Either<String, DeviceType>>) {
        this.deviceType = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("olfhredhxtpibnbq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("scqqtaqwgwkmqntx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vghalgauhlymksis")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Resource name for the device resource.
     */
    @JvmName("mhgigwrrmcsdafvr")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value The type of the device.
     */
    @JvmName("crgduebyjhcigsik")
    public suspend fun deviceType(`value`: Either<String, DeviceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceType = mapped
    }

    /**
     * @param value The type of the device.
     */
    @JvmName("lbiiatvxapsgcqal")
    public fun deviceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeviceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deviceType = mapped
    }

    /**
     * @param value The type of the device.
     */
    @JvmName("gflfsvrlshavjgwb")
    public fun deviceType(`value`: DeviceType) {
        val toBeMapped = Either.ofRight<String, DeviceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deviceType = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fmixnltteuhwgsci")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lcpwtkuuvdxeklon")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bpueqegoniwjbkdb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("bomkdrwrmrgghkwx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DeviceArgs = DeviceArgs(
        deviceName = deviceName,
        deviceType = deviceType,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
