@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.HybridnetworkFunctions.getArtifactManifestPlain
import com.pulumi.azurenative.hybridnetwork.HybridnetworkFunctions.getArtifactStorePlain
import com.pulumi.azurenative.hybridnetwork.HybridnetworkFunctions.getConfigurationGroupSchemaPlain
import com.pulumi.azurenative.hybridnetwork.HybridnetworkFunctions.getConfigurationGroupValuePlain
import com.pulumi.azurenative.hybridnetwork.HybridnetworkFunctions.getDevicePlain
import com.pulumi.azurenative.hybridnetwork.HybridnetworkFunctions.getNetworkFunctionDefinitionGroupPlain
import com.pulumi.azurenative.hybridnetwork.HybridnetworkFunctions.getNetworkFunctionDefinitionVersionPlain
import com.pulumi.azurenative.hybridnetwork.HybridnetworkFunctions.getNetworkFunctionPlain
import com.pulumi.azurenative.hybridnetwork.HybridnetworkFunctions.getNetworkServiceDesignGroupPlain
import com.pulumi.azurenative.hybridnetwork.HybridnetworkFunctions.getNetworkServiceDesignVersionPlain
import com.pulumi.azurenative.hybridnetwork.HybridnetworkFunctions.getPublisherPlain
import com.pulumi.azurenative.hybridnetwork.HybridnetworkFunctions.getSiteNetworkServicePlain
import com.pulumi.azurenative.hybridnetwork.HybridnetworkFunctions.getSitePlain
import com.pulumi.azurenative.hybridnetwork.HybridnetworkFunctions.getVendorPlain
import com.pulumi.azurenative.hybridnetwork.HybridnetworkFunctions.getVendorSkuPreviewPlain
import com.pulumi.azurenative.hybridnetwork.HybridnetworkFunctions.getVendorSkusPlain
import com.pulumi.azurenative.hybridnetwork.HybridnetworkFunctions.listArtifactManifestCredentialPlain
import com.pulumi.azurenative.hybridnetwork.HybridnetworkFunctions.listDeviceRegistrationKeyPlain
import com.pulumi.azurenative.hybridnetwork.HybridnetworkFunctions.listVendorSkusCredentialPlain
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetArtifactManifestPlainArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetArtifactManifestPlainArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetArtifactStorePlainArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetArtifactStorePlainArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetConfigurationGroupSchemaPlainArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetConfigurationGroupSchemaPlainArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetConfigurationGroupValuePlainArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetConfigurationGroupValuePlainArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetDevicePlainArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetDevicePlainArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetNetworkFunctionDefinitionGroupPlainArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetNetworkFunctionDefinitionGroupPlainArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetNetworkFunctionDefinitionVersionPlainArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetNetworkFunctionDefinitionVersionPlainArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetNetworkFunctionPlainArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetNetworkFunctionPlainArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetNetworkServiceDesignGroupPlainArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetNetworkServiceDesignGroupPlainArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetNetworkServiceDesignVersionPlainArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetNetworkServiceDesignVersionPlainArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetPublisherPlainArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetPublisherPlainArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetSiteNetworkServicePlainArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetSiteNetworkServicePlainArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetSitePlainArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetSitePlainArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetVendorPlainArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetVendorPlainArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetVendorSkuPreviewPlainArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetVendorSkuPreviewPlainArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetVendorSkusPlainArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.GetVendorSkusPlainArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.ListArtifactManifestCredentialPlainArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.ListArtifactManifestCredentialPlainArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.ListDeviceRegistrationKeyPlainArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.ListDeviceRegistrationKeyPlainArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.ListVendorSkusCredentialPlainArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.ListVendorSkusCredentialPlainArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetArtifactManifestResult
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetArtifactStoreResult
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetConfigurationGroupSchemaResult
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetConfigurationGroupValueResult
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetDeviceResult
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetNetworkFunctionDefinitionGroupResult
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetNetworkFunctionDefinitionVersionResult
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetNetworkFunctionResult
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetNetworkServiceDesignGroupResult
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetNetworkServiceDesignVersionResult
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetPublisherResult
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetSiteNetworkServiceResult
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetSiteResult
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetVendorResult
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetVendorSkuPreviewResult
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetVendorSkusResult
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ListArtifactManifestCredentialResult
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ListDeviceRegistrationKeyResult
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ListVendorSkusCredentialResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetArtifactManifestResult.Companion.toKotlin as getArtifactManifestResultToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetArtifactStoreResult.Companion.toKotlin as getArtifactStoreResultToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetConfigurationGroupSchemaResult.Companion.toKotlin as getConfigurationGroupSchemaResultToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetConfigurationGroupValueResult.Companion.toKotlin as getConfigurationGroupValueResultToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetDeviceResult.Companion.toKotlin as getDeviceResultToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetNetworkFunctionDefinitionGroupResult.Companion.toKotlin as getNetworkFunctionDefinitionGroupResultToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetNetworkFunctionDefinitionVersionResult.Companion.toKotlin as getNetworkFunctionDefinitionVersionResultToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetNetworkFunctionResult.Companion.toKotlin as getNetworkFunctionResultToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetNetworkServiceDesignGroupResult.Companion.toKotlin as getNetworkServiceDesignGroupResultToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetNetworkServiceDesignVersionResult.Companion.toKotlin as getNetworkServiceDesignVersionResultToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetPublisherResult.Companion.toKotlin as getPublisherResultToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetSiteNetworkServiceResult.Companion.toKotlin as getSiteNetworkServiceResultToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetSiteResult.Companion.toKotlin as getSiteResultToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetVendorResult.Companion.toKotlin as getVendorResultToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetVendorSkuPreviewResult.Companion.toKotlin as getVendorSkuPreviewResultToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.GetVendorSkusResult.Companion.toKotlin as getVendorSkusResultToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ListArtifactManifestCredentialResult.Companion.toKotlin as listArtifactManifestCredentialResultToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ListDeviceRegistrationKeyResult.Companion.toKotlin as listDeviceRegistrationKeyResultToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ListVendorSkusCredentialResult.Companion.toKotlin as listVendorSkusCredentialResultToKotlin

public object HybridnetworkFunctions {
    /**
     * Gets information about a artifact manifest resource.
     * Azure REST API version: 2023-09-01.
     * @param argument null
     * @return Artifact manifest properties.
     */
    public suspend fun getArtifactManifest(argument: GetArtifactManifestPlainArgs): GetArtifactManifestResult =
        getArtifactManifestResultToKotlin(getArtifactManifestPlain(argument.toJava()).await())

    /**
     * @see [getArtifactManifest].
     * @param artifactManifestName The name of the artifact manifest.
     * @param artifactStoreName The name of the artifact store.
     * @param publisherName The name of the publisher.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Artifact manifest properties.
     */
    public suspend fun getArtifactManifest(
        artifactManifestName: String,
        artifactStoreName: String,
        publisherName: String,
        resourceGroupName: String,
    ): GetArtifactManifestResult {
        val argument = GetArtifactManifestPlainArgs(
            artifactManifestName = artifactManifestName,
            artifactStoreName = artifactStoreName,
            publisherName = publisherName,
            resourceGroupName = resourceGroupName,
        )
        return getArtifactManifestResultToKotlin(getArtifactManifestPlain(argument.toJava()).await())
    }

    /**
     * @see [getArtifactManifest].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridnetwork&#46;kotlin&#46;inputs&#46;GetArtifactManifestPlainArgs].
     * @return Artifact manifest properties.
     */
    public suspend fun getArtifactManifest(argument: suspend GetArtifactManifestPlainArgsBuilder.() -> Unit): GetArtifactManifestResult {
        val builder = GetArtifactManifestPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getArtifactManifestResultToKotlin(getArtifactManifestPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified artifact store.
     * Azure REST API version: 2023-09-01.
     * @param argument null
     * @return Artifact store properties.
     */
    public suspend fun getArtifactStore(argument: GetArtifactStorePlainArgs): GetArtifactStoreResult =
        getArtifactStoreResultToKotlin(getArtifactStorePlain(argument.toJava()).await())

    /**
     * @see [getArtifactStore].
     * @param artifactStoreName The name of the artifact store.
     * @param publisherName The name of the publisher.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Artifact store properties.
     */
    public suspend fun getArtifactStore(
        artifactStoreName: String,
        publisherName: String,
        resourceGroupName: String,
    ): GetArtifactStoreResult {
        val argument = GetArtifactStorePlainArgs(
            artifactStoreName = artifactStoreName,
            publisherName = publisherName,
            resourceGroupName = resourceGroupName,
        )
        return getArtifactStoreResultToKotlin(getArtifactStorePlain(argument.toJava()).await())
    }

    /**
     * @see [getArtifactStore].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridnetwork&#46;kotlin&#46;inputs&#46;GetArtifactStorePlainArgs].
     * @return Artifact store properties.
     */
    public suspend fun getArtifactStore(argument: suspend GetArtifactStorePlainArgsBuilder.() -> Unit): GetArtifactStoreResult {
        val builder = GetArtifactStorePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getArtifactStoreResultToKotlin(getArtifactStorePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified configuration group schema.
     * Azure REST API version: 2023-09-01.
     * @param argument null
     * @return Configuration group schema resource.
     */
    public suspend fun getConfigurationGroupSchema(argument: GetConfigurationGroupSchemaPlainArgs): GetConfigurationGroupSchemaResult =
        getConfigurationGroupSchemaResultToKotlin(getConfigurationGroupSchemaPlain(argument.toJava()).await())

    /**
     * @see [getConfigurationGroupSchema].
     * @param configurationGroupSchemaName The name of the configuration group schema.
     * @param publisherName The name of the publisher.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Configuration group schema resource.
     */
    public suspend fun getConfigurationGroupSchema(
        configurationGroupSchemaName: String,
        publisherName: String,
        resourceGroupName: String,
    ): GetConfigurationGroupSchemaResult {
        val argument = GetConfigurationGroupSchemaPlainArgs(
            configurationGroupSchemaName = configurationGroupSchemaName,
            publisherName = publisherName,
            resourceGroupName = resourceGroupName,
        )
        return getConfigurationGroupSchemaResultToKotlin(getConfigurationGroupSchemaPlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigurationGroupSchema].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridnetwork&#46;kotlin&#46;inputs&#46;GetConfigurationGroupSchemaPlainArgs].
     * @return Configuration group schema resource.
     */
    public suspend fun getConfigurationGroupSchema(argument: suspend GetConfigurationGroupSchemaPlainArgsBuilder.() -> Unit): GetConfigurationGroupSchemaResult {
        val builder = GetConfigurationGroupSchemaPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationGroupSchemaResultToKotlin(getConfigurationGroupSchemaPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified hybrid configuration group values.
     * Azure REST API version: 2023-09-01.
     * @param argument null
     * @return Hybrid configuration group value resource.
     */
    public suspend fun getConfigurationGroupValue(argument: GetConfigurationGroupValuePlainArgs): GetConfigurationGroupValueResult =
        getConfigurationGroupValueResultToKotlin(getConfigurationGroupValuePlain(argument.toJava()).await())

    /**
     * @see [getConfigurationGroupValue].
     * @param configurationGroupValueName The name of the configuration group value.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Hybrid configuration group value resource.
     */
    public suspend fun getConfigurationGroupValue(
        configurationGroupValueName: String,
        resourceGroupName: String,
    ): GetConfigurationGroupValueResult {
        val argument = GetConfigurationGroupValuePlainArgs(
            configurationGroupValueName = configurationGroupValueName,
            resourceGroupName = resourceGroupName,
        )
        return getConfigurationGroupValueResultToKotlin(getConfigurationGroupValuePlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigurationGroupValue].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridnetwork&#46;kotlin&#46;inputs&#46;GetConfigurationGroupValuePlainArgs].
     * @return Hybrid configuration group value resource.
     */
    public suspend fun getConfigurationGroupValue(argument: suspend GetConfigurationGroupValuePlainArgsBuilder.() -> Unit): GetConfigurationGroupValueResult {
        val builder = GetConfigurationGroupValuePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationGroupValueResultToKotlin(getConfigurationGroupValuePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified device.
     * Azure REST API version: 2022-01-01-preview.
     * @param argument null
     * @return Device resource.
     */
    public suspend fun getDevice(argument: GetDevicePlainArgs): GetDeviceResult =
        getDeviceResultToKotlin(getDevicePlain(argument.toJava()).await())

    /**
     * @see [getDevice].
     * @param deviceName The name of the device resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Device resource.
     */
    public suspend fun getDevice(deviceName: String, resourceGroupName: String): GetDeviceResult {
        val argument = GetDevicePlainArgs(
            deviceName = deviceName,
            resourceGroupName = resourceGroupName,
        )
        return getDeviceResultToKotlin(getDevicePlain(argument.toJava()).await())
    }

    /**
     * @see [getDevice].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridnetwork&#46;kotlin&#46;inputs&#46;GetDevicePlainArgs].
     * @return Device resource.
     */
    public suspend fun getDevice(argument: suspend GetDevicePlainArgsBuilder.() -> Unit): GetDeviceResult {
        val builder = GetDevicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeviceResultToKotlin(getDevicePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified network function resource.
     * Azure REST API version: 2022-01-01-preview.
     * Other available API versions: 2023-09-01.
     * @param argument null
     * @return Network function resource response.
     */
    public suspend fun getNetworkFunction(argument: GetNetworkFunctionPlainArgs): GetNetworkFunctionResult =
        getNetworkFunctionResultToKotlin(getNetworkFunctionPlain(argument.toJava()).await())

    /**
     * @see [getNetworkFunction].
     * @param networkFunctionName The name of the network function resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Network function resource response.
     */
    public suspend fun getNetworkFunction(networkFunctionName: String, resourceGroupName: String): GetNetworkFunctionResult {
        val argument = GetNetworkFunctionPlainArgs(
            networkFunctionName = networkFunctionName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkFunctionResultToKotlin(getNetworkFunctionPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkFunction].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridnetwork&#46;kotlin&#46;inputs&#46;GetNetworkFunctionPlainArgs].
     * @return Network function resource response.
     */
    public suspend fun getNetworkFunction(argument: suspend GetNetworkFunctionPlainArgsBuilder.() -> Unit): GetNetworkFunctionResult {
        val builder = GetNetworkFunctionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkFunctionResultToKotlin(getNetworkFunctionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified networkFunctionDefinition group.
     * Azure REST API version: 2023-09-01.
     * @param argument null
     * @return Network function definition group resource.
     */
    public suspend fun getNetworkFunctionDefinitionGroup(argument: GetNetworkFunctionDefinitionGroupPlainArgs): GetNetworkFunctionDefinitionGroupResult =
        getNetworkFunctionDefinitionGroupResultToKotlin(getNetworkFunctionDefinitionGroupPlain(argument.toJava()).await())

    /**
     * @see [getNetworkFunctionDefinitionGroup].
     * @param networkFunctionDefinitionGroupName The name of the network function definition group.
     * @param publisherName The name of the publisher.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Network function definition group resource.
     */
    public suspend fun getNetworkFunctionDefinitionGroup(
        networkFunctionDefinitionGroupName: String,
        publisherName: String,
        resourceGroupName: String,
    ): GetNetworkFunctionDefinitionGroupResult {
        val argument = GetNetworkFunctionDefinitionGroupPlainArgs(
            networkFunctionDefinitionGroupName = networkFunctionDefinitionGroupName,
            publisherName = publisherName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkFunctionDefinitionGroupResultToKotlin(getNetworkFunctionDefinitionGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkFunctionDefinitionGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridnetwork&#46;kotlin&#46;inputs&#46;GetNetworkFunctionDefinitionGroupPlainArgs].
     * @return Network function definition group resource.
     */
    public suspend fun getNetworkFunctionDefinitionGroup(argument: suspend GetNetworkFunctionDefinitionGroupPlainArgsBuilder.() -> Unit): GetNetworkFunctionDefinitionGroupResult {
        val builder = GetNetworkFunctionDefinitionGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkFunctionDefinitionGroupResultToKotlin(getNetworkFunctionDefinitionGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a network function definition version.
     * Azure REST API version: 2023-09-01.
     * @param argument null
     * @return Network function definition version.
     */
    public suspend fun getNetworkFunctionDefinitionVersion(argument: GetNetworkFunctionDefinitionVersionPlainArgs): GetNetworkFunctionDefinitionVersionResult =
        getNetworkFunctionDefinitionVersionResultToKotlin(getNetworkFunctionDefinitionVersionPlain(argument.toJava()).await())

    /**
     * @see [getNetworkFunctionDefinitionVersion].
     * @param networkFunctionDefinitionGroupName The name of the network function definition group.
     * @param networkFunctionDefinitionVersionName The name of the network function definition version. The name should conform to the SemVer 2.0.0 specification: https://semver.org/spec/v2.0.0.html.
     * @param publisherName The name of the publisher.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Network function definition version.
     */
    public suspend fun getNetworkFunctionDefinitionVersion(
        networkFunctionDefinitionGroupName: String,
        networkFunctionDefinitionVersionName: String,
        publisherName: String,
        resourceGroupName: String,
    ): GetNetworkFunctionDefinitionVersionResult {
        val argument = GetNetworkFunctionDefinitionVersionPlainArgs(
            networkFunctionDefinitionGroupName = networkFunctionDefinitionGroupName,
            networkFunctionDefinitionVersionName = networkFunctionDefinitionVersionName,
            publisherName = publisherName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkFunctionDefinitionVersionResultToKotlin(getNetworkFunctionDefinitionVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkFunctionDefinitionVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridnetwork&#46;kotlin&#46;inputs&#46;GetNetworkFunctionDefinitionVersionPlainArgs].
     * @return Network function definition version.
     */
    public suspend fun getNetworkFunctionDefinitionVersion(argument: suspend GetNetworkFunctionDefinitionVersionPlainArgsBuilder.() -> Unit): GetNetworkFunctionDefinitionVersionResult {
        val builder = GetNetworkFunctionDefinitionVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkFunctionDefinitionVersionResultToKotlin(getNetworkFunctionDefinitionVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified networkServiceDesign group.
     * Azure REST API version: 2023-09-01.
     * @param argument null
     * @return network service design group resource.
     */
    public suspend fun getNetworkServiceDesignGroup(argument: GetNetworkServiceDesignGroupPlainArgs): GetNetworkServiceDesignGroupResult =
        getNetworkServiceDesignGroupResultToKotlin(getNetworkServiceDesignGroupPlain(argument.toJava()).await())

    /**
     * @see [getNetworkServiceDesignGroup].
     * @param networkServiceDesignGroupName The name of the network service design group.
     * @param publisherName The name of the publisher.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return network service design group resource.
     */
    public suspend fun getNetworkServiceDesignGroup(
        networkServiceDesignGroupName: String,
        publisherName: String,
        resourceGroupName: String,
    ): GetNetworkServiceDesignGroupResult {
        val argument = GetNetworkServiceDesignGroupPlainArgs(
            networkServiceDesignGroupName = networkServiceDesignGroupName,
            publisherName = publisherName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkServiceDesignGroupResultToKotlin(getNetworkServiceDesignGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkServiceDesignGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridnetwork&#46;kotlin&#46;inputs&#46;GetNetworkServiceDesignGroupPlainArgs].
     * @return network service design group resource.
     */
    public suspend fun getNetworkServiceDesignGroup(argument: suspend GetNetworkServiceDesignGroupPlainArgsBuilder.() -> Unit): GetNetworkServiceDesignGroupResult {
        val builder = GetNetworkServiceDesignGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkServiceDesignGroupResultToKotlin(getNetworkServiceDesignGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a network service design version.
     * Azure REST API version: 2023-09-01.
     * @param argument null
     * @return network service design version.
     */
    public suspend fun getNetworkServiceDesignVersion(argument: GetNetworkServiceDesignVersionPlainArgs): GetNetworkServiceDesignVersionResult =
        getNetworkServiceDesignVersionResultToKotlin(getNetworkServiceDesignVersionPlain(argument.toJava()).await())

    /**
     * @see [getNetworkServiceDesignVersion].
     * @param networkServiceDesignGroupName The name of the network service design group.
     * @param networkServiceDesignVersionName The name of the network service design version. The name should conform to the SemVer 2.0.0 specification: https://semver.org/spec/v2.0.0.html.
     * @param publisherName The name of the publisher.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return network service design version.
     */
    public suspend fun getNetworkServiceDesignVersion(
        networkServiceDesignGroupName: String,
        networkServiceDesignVersionName: String,
        publisherName: String,
        resourceGroupName: String,
    ): GetNetworkServiceDesignVersionResult {
        val argument = GetNetworkServiceDesignVersionPlainArgs(
            networkServiceDesignGroupName = networkServiceDesignGroupName,
            networkServiceDesignVersionName = networkServiceDesignVersionName,
            publisherName = publisherName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkServiceDesignVersionResultToKotlin(getNetworkServiceDesignVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkServiceDesignVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridnetwork&#46;kotlin&#46;inputs&#46;GetNetworkServiceDesignVersionPlainArgs].
     * @return network service design version.
     */
    public suspend fun getNetworkServiceDesignVersion(argument: suspend GetNetworkServiceDesignVersionPlainArgsBuilder.() -> Unit): GetNetworkServiceDesignVersionResult {
        val builder = GetNetworkServiceDesignVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkServiceDesignVersionResultToKotlin(getNetworkServiceDesignVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified publisher.
     * Azure REST API version: 2023-09-01.
     * @param argument null
     * @return publisher resource.
     */
    public suspend fun getPublisher(argument: GetPublisherPlainArgs): GetPublisherResult =
        getPublisherResultToKotlin(getPublisherPlain(argument.toJava()).await())

    /**
     * @see [getPublisher].
     * @param publisherName The name of the publisher.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return publisher resource.
     */
    public suspend fun getPublisher(publisherName: String, resourceGroupName: String): GetPublisherResult {
        val argument = GetPublisherPlainArgs(
            publisherName = publisherName,
            resourceGroupName = resourceGroupName,
        )
        return getPublisherResultToKotlin(getPublisherPlain(argument.toJava()).await())
    }

    /**
     * @see [getPublisher].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridnetwork&#46;kotlin&#46;inputs&#46;GetPublisherPlainArgs].
     * @return publisher resource.
     */
    public suspend fun getPublisher(argument: suspend GetPublisherPlainArgsBuilder.() -> Unit): GetPublisherResult {
        val builder = GetPublisherPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPublisherResultToKotlin(getPublisherPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified network site.
     * Azure REST API version: 2023-09-01.
     * @param argument null
     * @return Site resource.
     */
    public suspend fun getSite(argument: GetSitePlainArgs): GetSiteResult =
        getSiteResultToKotlin(getSitePlain(argument.toJava()).await())

    /**
     * @see [getSite].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName The name of the network service site.
     * @return Site resource.
     */
    public suspend fun getSite(resourceGroupName: String, siteName: String): GetSiteResult {
        val argument = GetSitePlainArgs(
            resourceGroupName = resourceGroupName,
            siteName = siteName,
        )
        return getSiteResultToKotlin(getSitePlain(argument.toJava()).await())
    }

    /**
     * @see [getSite].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridnetwork&#46;kotlin&#46;inputs&#46;GetSitePlainArgs].
     * @return Site resource.
     */
    public suspend fun getSite(argument: suspend GetSitePlainArgsBuilder.() -> Unit): GetSiteResult {
        val builder = GetSitePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSiteResultToKotlin(getSitePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified site network service.
     * Azure REST API version: 2023-09-01.
     * @param argument null
     * @return Site network service resource.
     */
    public suspend fun getSiteNetworkService(argument: GetSiteNetworkServicePlainArgs): GetSiteNetworkServiceResult =
        getSiteNetworkServiceResultToKotlin(getSiteNetworkServicePlain(argument.toJava()).await())

    /**
     * @see [getSiteNetworkService].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteNetworkServiceName The name of the site network service.
     * @return Site network service resource.
     */
    public suspend fun getSiteNetworkService(
        resourceGroupName: String,
        siteNetworkServiceName: String,
    ): GetSiteNetworkServiceResult {
        val argument = GetSiteNetworkServicePlainArgs(
            resourceGroupName = resourceGroupName,
            siteNetworkServiceName = siteNetworkServiceName,
        )
        return getSiteNetworkServiceResultToKotlin(getSiteNetworkServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getSiteNetworkService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridnetwork&#46;kotlin&#46;inputs&#46;GetSiteNetworkServicePlainArgs].
     * @return Site network service resource.
     */
    public suspend fun getSiteNetworkService(argument: suspend GetSiteNetworkServicePlainArgsBuilder.() -> Unit): GetSiteNetworkServiceResult {
        val builder = GetSiteNetworkServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSiteNetworkServiceResultToKotlin(getSiteNetworkServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified vendor.
     * Azure REST API version: 2022-01-01-preview.
     * @param argument null
     * @return Vendor resource.
     */
    public suspend fun getVendor(argument: GetVendorPlainArgs): GetVendorResult =
        getVendorResultToKotlin(getVendorPlain(argument.toJava()).await())

    /**
     * @see [getVendor].
     * @param vendorName The name of the vendor.
     * @return Vendor resource.
     */
    public suspend fun getVendor(vendorName: String): GetVendorResult {
        val argument = GetVendorPlainArgs(
            vendorName = vendorName,
        )
        return getVendorResultToKotlin(getVendorPlain(argument.toJava()).await())
    }

    /**
     * @see [getVendor].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridnetwork&#46;kotlin&#46;inputs&#46;GetVendorPlainArgs].
     * @return Vendor resource.
     */
    public suspend fun getVendor(argument: suspend GetVendorPlainArgsBuilder.() -> Unit): GetVendorResult {
        val builder = GetVendorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVendorResultToKotlin(getVendorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the preview information of a vendor sku.
     * Azure REST API version: 2022-01-01-preview.
     * @param argument null
     * @return Customer subscription which can use a sku.
     */
    public suspend fun getVendorSkuPreview(argument: GetVendorSkuPreviewPlainArgs): GetVendorSkuPreviewResult =
        getVendorSkuPreviewResultToKotlin(getVendorSkuPreviewPlain(argument.toJava()).await())

    /**
     * @see [getVendorSkuPreview].
     * @param previewSubscription Preview subscription ID.
     * @param skuName The name of the vendor sku.
     * @param vendorName The name of the vendor.
     * @return Customer subscription which can use a sku.
     */
    public suspend fun getVendorSkuPreview(
        previewSubscription: String,
        skuName: String,
        vendorName: String,
    ): GetVendorSkuPreviewResult {
        val argument = GetVendorSkuPreviewPlainArgs(
            previewSubscription = previewSubscription,
            skuName = skuName,
            vendorName = vendorName,
        )
        return getVendorSkuPreviewResultToKotlin(getVendorSkuPreviewPlain(argument.toJava()).await())
    }

    /**
     * @see [getVendorSkuPreview].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridnetwork&#46;kotlin&#46;inputs&#46;GetVendorSkuPreviewPlainArgs].
     * @return Customer subscription which can use a sku.
     */
    public suspend fun getVendorSkuPreview(argument: suspend GetVendorSkuPreviewPlainArgsBuilder.() -> Unit): GetVendorSkuPreviewResult {
        val builder = GetVendorSkuPreviewPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVendorSkuPreviewResultToKotlin(getVendorSkuPreviewPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified sku.
     * Azure REST API version: 2022-01-01-preview.
     * @param argument null
     * @return Sku sub resource.
     */
    public suspend fun getVendorSkus(argument: GetVendorSkusPlainArgs): GetVendorSkusResult =
        getVendorSkusResultToKotlin(getVendorSkusPlain(argument.toJava()).await())

    /**
     * @see [getVendorSkus].
     * @param skuName The name of the sku.
     * @param vendorName The name of the vendor.
     * @return Sku sub resource.
     */
    public suspend fun getVendorSkus(skuName: String, vendorName: String): GetVendorSkusResult {
        val argument = GetVendorSkusPlainArgs(
            skuName = skuName,
            vendorName = vendorName,
        )
        return getVendorSkusResultToKotlin(getVendorSkusPlain(argument.toJava()).await())
    }

    /**
     * @see [getVendorSkus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridnetwork&#46;kotlin&#46;inputs&#46;GetVendorSkusPlainArgs].
     * @return Sku sub resource.
     */
    public suspend fun getVendorSkus(argument: suspend GetVendorSkusPlainArgsBuilder.() -> Unit): GetVendorSkusResult {
        val builder = GetVendorSkusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVendorSkusResultToKotlin(getVendorSkusPlain(builtArgument.toJava()).await())
    }

    /**
     * List credential for publishing artifacts defined in artifact manifest.
     * Azure REST API version: 2023-09-01.
     * @param argument null
     * @return The artifact manifest credential definition.
     */
    public suspend fun listArtifactManifestCredential(argument: ListArtifactManifestCredentialPlainArgs): ListArtifactManifestCredentialResult =
        listArtifactManifestCredentialResultToKotlin(listArtifactManifestCredentialPlain(argument.toJava()).await())

    /**
     * @see [listArtifactManifestCredential].
     * @param artifactManifestName The name of the artifact manifest.
     * @param artifactStoreName The name of the artifact store.
     * @param publisherName The name of the publisher.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The artifact manifest credential definition.
     */
    public suspend fun listArtifactManifestCredential(
        artifactManifestName: String,
        artifactStoreName: String,
        publisherName: String,
        resourceGroupName: String,
    ): ListArtifactManifestCredentialResult {
        val argument = ListArtifactManifestCredentialPlainArgs(
            artifactManifestName = artifactManifestName,
            artifactStoreName = artifactStoreName,
            publisherName = publisherName,
            resourceGroupName = resourceGroupName,
        )
        return listArtifactManifestCredentialResultToKotlin(listArtifactManifestCredentialPlain(argument.toJava()).await())
    }

    /**
     * @see [listArtifactManifestCredential].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridnetwork&#46;kotlin&#46;inputs&#46;ListArtifactManifestCredentialPlainArgs].
     * @return The artifact manifest credential definition.
     */
    public suspend fun listArtifactManifestCredential(argument: suspend ListArtifactManifestCredentialPlainArgsBuilder.() -> Unit): ListArtifactManifestCredentialResult {
        val builder = ListArtifactManifestCredentialPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listArtifactManifestCredentialResultToKotlin(listArtifactManifestCredentialPlain(builtArgument.toJava()).await())
    }

    /**
     * List the registration key for the device.
     * Azure REST API version: 2022-01-01-preview.
     * @param argument null
     * @return The device registration key.
     */
    public suspend fun listDeviceRegistrationKey(argument: ListDeviceRegistrationKeyPlainArgs): ListDeviceRegistrationKeyResult =
        listDeviceRegistrationKeyResultToKotlin(listDeviceRegistrationKeyPlain(argument.toJava()).await())

    /**
     * @see [listDeviceRegistrationKey].
     * @param deviceName The name of the device resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The device registration key.
     */
    public suspend fun listDeviceRegistrationKey(deviceName: String, resourceGroupName: String): ListDeviceRegistrationKeyResult {
        val argument = ListDeviceRegistrationKeyPlainArgs(
            deviceName = deviceName,
            resourceGroupName = resourceGroupName,
        )
        return listDeviceRegistrationKeyResultToKotlin(listDeviceRegistrationKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [listDeviceRegistrationKey].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridnetwork&#46;kotlin&#46;inputs&#46;ListDeviceRegistrationKeyPlainArgs].
     * @return The device registration key.
     */
    public suspend fun listDeviceRegistrationKey(argument: suspend ListDeviceRegistrationKeyPlainArgsBuilder.() -> Unit): ListDeviceRegistrationKeyResult {
        val builder = ListDeviceRegistrationKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listDeviceRegistrationKeyResultToKotlin(listDeviceRegistrationKeyPlain(builtArgument.toJava()).await())
    }

    /**
     * Generate credentials for publishing SKU images.
     * Azure REST API version: 2022-01-01-preview.
     * @param argument null
     * @return The Sku credential definition.
     */
    public suspend fun listVendorSkusCredential(argument: ListVendorSkusCredentialPlainArgs): ListVendorSkusCredentialResult =
        listVendorSkusCredentialResultToKotlin(listVendorSkusCredentialPlain(argument.toJava()).await())

    /**
     * @see [listVendorSkusCredential].
     * @param skuName The name of the sku.
     * @param vendorName The name of the vendor.
     * @return The Sku credential definition.
     */
    public suspend fun listVendorSkusCredential(skuName: String, vendorName: String): ListVendorSkusCredentialResult {
        val argument = ListVendorSkusCredentialPlainArgs(
            skuName = skuName,
            vendorName = vendorName,
        )
        return listVendorSkusCredentialResultToKotlin(listVendorSkusCredentialPlain(argument.toJava()).await())
    }

    /**
     * @see [listVendorSkusCredential].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridnetwork&#46;kotlin&#46;inputs&#46;ListVendorSkusCredentialPlainArgs].
     * @return The Sku credential definition.
     */
    public suspend fun listVendorSkusCredential(argument: suspend ListVendorSkusCredentialPlainArgsBuilder.() -> Unit): ListVendorSkusCredentialResult {
        val builder = ListVendorSkusCredentialPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listVendorSkusCredentialResultToKotlin(listVendorSkusCredentialPlain(builtArgument.toJava()).await())
    }
}
