@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.NetworkFunctionUserConfigurationResponse
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.NetworkFunctionUserConfigurationResponse.Companion.toKotlin as networkFunctionUserConfigurationResponseToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [NetworkFunction].
 */
@PulumiTagMarker
public class NetworkFunctionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkFunctionArgs = NetworkFunctionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkFunctionArgsBuilder.() -> Unit) {
        val builder = NetworkFunctionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkFunction {
        val builtJavaResource =
            com.pulumi.azurenative.hybridnetwork.NetworkFunction(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkFunction(builtJavaResource)
    }
}

/**
 * Network function resource response.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2020-01-01-preview.
 * Other available API versions: 2023-09-01.
 * ## Example Usage
 * ### Create network function resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkFunction = new AzureNative.HybridNetwork.NetworkFunction("networkFunction", new()
 *     {
 *         Device = new AzureNative.HybridNetwork.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/devices/testDevice",
 *         },
 *         Location = "eastus",
 *         ManagedApplicationParameters = null,
 *         NetworkFunctionName = "testNf",
 *         NetworkFunctionUserConfigurations = new[]
 *         {
 *             new AzureNative.HybridNetwork.Inputs.NetworkFunctionUserConfigurationArgs
 *             {
 *                 NetworkInterfaces = new[]
 *                 {
 *                     new AzureNative.HybridNetwork.Inputs.NetworkInterfaceArgs
 *                     {
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.HybridNetwork.Inputs.NetworkInterfaceIPConfigurationArgs
 *                             {
 *                                 Gateway = "",
 *                                 IpAddress = "",
 *                                 IpAllocationMethod = AzureNative.HybridNetwork.IPAllocationMethod.Dynamic,
 *                                 IpVersion = AzureNative.HybridNetwork.IPVersion.IPv4,
 *                                 Subnet = "",
 *                             },
 *                         },
 *                         MacAddress = "",
 *                         NetworkInterfaceName = "nic1",
 *                         VmSwitchType = AzureNative.HybridNetwork.VMSwitchType.Management,
 *                     },
 *                     new AzureNative.HybridNetwork.Inputs.NetworkInterfaceArgs
 *                     {
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.HybridNetwork.Inputs.NetworkInterfaceIPConfigurationArgs
 *                             {
 *                                 Gateway = "",
 *                                 IpAddress = "",
 *                                 IpAllocationMethod = AzureNative.HybridNetwork.IPAllocationMethod.Dynamic,
 *                                 IpVersion = AzureNative.HybridNetwork.IPVersion.IPv4,
 *                                 Subnet = "",
 *                             },
 *                         },
 *                         MacAddress = "DC-97-F8-79-16-7D",
 *                         NetworkInterfaceName = "nic2",
 *                         VmSwitchType = AzureNative.HybridNetwork.VMSwitchType.Wan,
 *                     },
 *                 },
 *                 RoleName = "testRole",
 *                 UserDataParameters = null,
 *             },
 *         },
 *         ResourceGroupName = "rg",
 *         SkuName = "testSku",
 *         VendorName = "testVendor",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewNetworkFunction(ctx, "networkFunction", &hybridnetwork.NetworkFunctionArgs{
 * 			Device: &hybridnetwork.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/devices/testDevice"),
 * 			},
 * 			Location:                     pulumi.String("eastus"),
 * 			ManagedApplicationParameters: pulumi.Any(nil),
 * 			NetworkFunctionName:          pulumi.String("testNf"),
 * 			NetworkFunctionUserConfigurations: hybridnetwork.NetworkFunctionUserConfigurationArray{
 * 				&hybridnetwork.NetworkFunctionUserConfigurationArgs{
 * 					NetworkInterfaces: hybridnetwork.NetworkInterfaceArray{
 * 						&hybridnetwork.NetworkInterfaceArgs{
 * 							IpConfigurations: hybridnetwork.NetworkInterfaceIPConfigurationArray{
 * 								&hybridnetwork.NetworkInterfaceIPConfigurationArgs{
 * 									Gateway:            pulumi.String(""),
 * 									IpAddress:          pulumi.String(""),
 * 									IpAllocationMethod: pulumi.String(hybridnetwork.IPAllocationMethodDynamic),
 * 									IpVersion:          pulumi.String(hybridnetwork.IPVersionIPv4),
 * 									Subnet:             pulumi.String(""),
 * 								},
 * 							},
 * 							MacAddress:           pulumi.String(""),
 * 							NetworkInterfaceName: pulumi.String("nic1"),
 * 							VmSwitchType:         pulumi.String(hybridnetwork.VMSwitchTypeManagement),
 * 						},
 * 						&hybridnetwork.NetworkInterfaceArgs{
 * 							IpConfigurations: hybridnetwork.NetworkInterfaceIPConfigurationArray{
 * 								&hybridnetwork.NetworkInterfaceIPConfigurationArgs{
 * 									Gateway:            pulumi.String(""),
 * 									IpAddress:          pulumi.String(""),
 * 									IpAllocationMethod: pulumi.String(hybridnetwork.IPAllocationMethodDynamic),
 * 									IpVersion:          pulumi.String(hybridnetwork.IPVersionIPv4),
 * 									Subnet:             pulumi.String(""),
 * 								},
 * 							},
 * 							MacAddress:           pulumi.String("DC-97-F8-79-16-7D"),
 * 							NetworkInterfaceName: pulumi.String("nic2"),
 * 							VmSwitchType:         pulumi.String(hybridnetwork.VMSwitchTypeWan),
 * 						},
 * 					},
 * 					RoleName:           pulumi.String("testRole"),
 * 					UserDataParameters: pulumi.Any(nil),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			SkuName:           pulumi.String("testSku"),
 * 			VendorName:        pulumi.String("testVendor"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunction;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunctionArgs;
 * import com.pulumi.azurenative.hybridnetwork.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionUserConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkFunction = new NetworkFunction("networkFunction", NetworkFunctionArgs.builder()
 *             .device(SubResourceArgs.builder()
 *                 .id("/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/devices/testDevice")
 *                 .build())
 *             .location("eastus")
 *             .managedApplicationParameters()
 *             .networkFunctionName("testNf")
 *             .networkFunctionUserConfigurations(NetworkFunctionUserConfigurationArgs.builder()
 *                 .networkInterfaces(
 *                     NetworkInterfaceArgs.builder()
 *                         .ipConfigurations(NetworkInterfaceIPConfigurationArgs.builder()
 *                             .gateway("")
 *                             .ipAddress("")
 *                             .ipAllocationMethod("Dynamic")
 *                             .ipVersion("IPv4")
 *                             .subnet("")
 *                             .build())
 *                         .macAddress("")
 *                         .networkInterfaceName("nic1")
 *                         .vmSwitchType("Management")
 *                         .build(),
 *                     NetworkInterfaceArgs.builder()
 *                         .ipConfigurations(NetworkInterfaceIPConfigurationArgs.builder()
 *                             .gateway("")
 *                             .ipAddress("")
 *                             .ipAllocationMethod("Dynamic")
 *                             .ipVersion("IPv4")
 *                             .subnet("")
 *                             .build())
 *                         .macAddress("DC-97-F8-79-16-7D")
 *                         .networkInterfaceName("nic2")
 *                         .vmSwitchType("Wan")
 *                         .build())
 *                 .roleName("testRole")
 *                 .userDataParameters()
 *                 .build())
 *             .resourceGroupName("rg")
 *             .skuName("testSku")
 *             .vendorName("testVendor")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:NetworkFunction testNf /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/networkFunctions/{networkFunctionName}
 * ```
 */
public class NetworkFunction internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridnetwork.NetworkFunction,
) : KotlinCustomResource(javaResource, NetworkFunctionMapper) {
    /**
     * The reference to the device resource. Once set, it cannot be updated.
     */
    public val device: Output<SubResourceResponse>?
        get() = javaResource.device().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The resource URI of the managed application.
     */
    public val managedApplication: Output<SubResourceResponse>
        get() = javaResource.managedApplication().applyValue({ args0 ->
            args0.let({ args0 ->
                subResourceResponseToKotlin(args0)
            })
        })

    /**
     * The parameters for the managed application.
     */
    public val managedApplicationParameters: Output<Any>?
        get() = javaResource.managedApplicationParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The network function container configurations from the user.
     */
    public val networkFunctionContainerConfigurations: Output<Any>?
        get() = javaResource.networkFunctionContainerConfigurations().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The network function configurations from the user.
     */
    public val networkFunctionUserConfigurations:
        Output<List<NetworkFunctionUserConfigurationResponse>>?
        get() = javaResource.networkFunctionUserConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        networkFunctionUserConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the network function resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The service key for the network function resource.
     */
    public val serviceKey: Output<String>
        get() = javaResource.serviceKey().applyValue({ args0 -> args0 })

    /**
     * The sku name for the network function. Once set, it cannot be updated.
     */
    public val skuName: Output<String>?
        get() = javaResource.skuName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The sku type for the network function.
     */
    public val skuType: Output<String>
        get() = javaResource.skuType().applyValue({ args0 -> args0 })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The vendor name for the network function. Once set, it cannot be updated.
     */
    public val vendorName: Output<String>?
        get() = javaResource.vendorName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The vendor provisioning state for the network function resource.
     */
    public val vendorProvisioningState: Output<String>
        get() = javaResource.vendorProvisioningState().applyValue({ args0 -> args0 })
}

public object NetworkFunctionMapper : ResourceMapper<NetworkFunction> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridnetwork.NetworkFunction::class == javaResource::class

    override fun map(javaResource: Resource): NetworkFunction = NetworkFunction(
        javaResource as
            com.pulumi.azurenative.hybridnetwork.NetworkFunction,
    )
}

/**
 * @see [NetworkFunction].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkFunction].
 */
public suspend fun networkFunction(
    name: String,
    block: suspend NetworkFunctionResourceBuilder.() -> Unit,
): NetworkFunction {
    val builder = NetworkFunctionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkFunction].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkFunction(name: String): NetworkFunction {
    val builder = NetworkFunctionResourceBuilder()
    builder.name(name)
    return builder.build()
}
