@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.NetworkFunctionArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.NetworkFunctionUserConfigurationArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.NetworkFunctionUserConfigurationArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Network function resource response.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2020-01-01-preview.
 * Other available API versions: 2023-09-01.
 * ## Example Usage
 * ### Create network function resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkFunction = new AzureNative.HybridNetwork.NetworkFunction("networkFunction", new()
 *     {
 *         Device = new AzureNative.HybridNetwork.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/devices/testDevice",
 *         },
 *         Location = "eastus",
 *         ManagedApplicationParameters = null,
 *         NetworkFunctionName = "testNf",
 *         NetworkFunctionUserConfigurations = new[]
 *         {
 *             new AzureNative.HybridNetwork.Inputs.NetworkFunctionUserConfigurationArgs
 *             {
 *                 NetworkInterfaces = new[]
 *                 {
 *                     new AzureNative.HybridNetwork.Inputs.NetworkInterfaceArgs
 *                     {
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.HybridNetwork.Inputs.NetworkInterfaceIPConfigurationArgs
 *                             {
 *                                 Gateway = "",
 *                                 IpAddress = "",
 *                                 IpAllocationMethod = AzureNative.HybridNetwork.IPAllocationMethod.Dynamic,
 *                                 IpVersion = AzureNative.HybridNetwork.IPVersion.IPv4,
 *                                 Subnet = "",
 *                             },
 *                         },
 *                         MacAddress = "",
 *                         NetworkInterfaceName = "nic1",
 *                         VmSwitchType = AzureNative.HybridNetwork.VMSwitchType.Management,
 *                     },
 *                     new AzureNative.HybridNetwork.Inputs.NetworkInterfaceArgs
 *                     {
 *                         IpConfigurations = new[]
 *                         {
 *                             new AzureNative.HybridNetwork.Inputs.NetworkInterfaceIPConfigurationArgs
 *                             {
 *                                 Gateway = "",
 *                                 IpAddress = "",
 *                                 IpAllocationMethod = AzureNative.HybridNetwork.IPAllocationMethod.Dynamic,
 *                                 IpVersion = AzureNative.HybridNetwork.IPVersion.IPv4,
 *                                 Subnet = "",
 *                             },
 *                         },
 *                         MacAddress = "DC-97-F8-79-16-7D",
 *                         NetworkInterfaceName = "nic2",
 *                         VmSwitchType = AzureNative.HybridNetwork.VMSwitchType.Wan,
 *                     },
 *                 },
 *                 RoleName = "testRole",
 *                 UserDataParameters = null,
 *             },
 *         },
 *         ResourceGroupName = "rg",
 *         SkuName = "testSku",
 *         VendorName = "testVendor",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewNetworkFunction(ctx, "networkFunction", &hybridnetwork.NetworkFunctionArgs{
 * 			Device: &hybridnetwork.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/devices/testDevice"),
 * 			},
 * 			Location:                     pulumi.String("eastus"),
 * 			ManagedApplicationParameters: pulumi.Any(nil),
 * 			NetworkFunctionName:          pulumi.String("testNf"),
 * 			NetworkFunctionUserConfigurations: hybridnetwork.NetworkFunctionUserConfigurationArray{
 * 				&hybridnetwork.NetworkFunctionUserConfigurationArgs{
 * 					NetworkInterfaces: hybridnetwork.NetworkInterfaceArray{
 * 						&hybridnetwork.NetworkInterfaceArgs{
 * 							IpConfigurations: hybridnetwork.NetworkInterfaceIPConfigurationArray{
 * 								&hybridnetwork.NetworkInterfaceIPConfigurationArgs{
 * 									Gateway:            pulumi.String(""),
 * 									IpAddress:          pulumi.String(""),
 * 									IpAllocationMethod: pulumi.String(hybridnetwork.IPAllocationMethodDynamic),
 * 									IpVersion:          pulumi.String(hybridnetwork.IPVersionIPv4),
 * 									Subnet:             pulumi.String(""),
 * 								},
 * 							},
 * 							MacAddress:           pulumi.String(""),
 * 							NetworkInterfaceName: pulumi.String("nic1"),
 * 							VmSwitchType:         pulumi.String(hybridnetwork.VMSwitchTypeManagement),
 * 						},
 * 						&hybridnetwork.NetworkInterfaceArgs{
 * 							IpConfigurations: hybridnetwork.NetworkInterfaceIPConfigurationArray{
 * 								&hybridnetwork.NetworkInterfaceIPConfigurationArgs{
 * 									Gateway:            pulumi.String(""),
 * 									IpAddress:          pulumi.String(""),
 * 									IpAllocationMethod: pulumi.String(hybridnetwork.IPAllocationMethodDynamic),
 * 									IpVersion:          pulumi.String(hybridnetwork.IPVersionIPv4),
 * 									Subnet:             pulumi.String(""),
 * 								},
 * 							},
 * 							MacAddress:           pulumi.String("DC-97-F8-79-16-7D"),
 * 							NetworkInterfaceName: pulumi.String("nic2"),
 * 							VmSwitchType:         pulumi.String(hybridnetwork.VMSwitchTypeWan),
 * 						},
 * 					},
 * 					RoleName:           pulumi.String("testRole"),
 * 					UserDataParameters: pulumi.Any(nil),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			SkuName:           pulumi.String("testSku"),
 * 			VendorName:        pulumi.String("testVendor"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunction;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunctionArgs;
 * import com.pulumi.azurenative.hybridnetwork.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionUserConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkFunction = new NetworkFunction("networkFunction", NetworkFunctionArgs.builder()
 *             .device(SubResourceArgs.builder()
 *                 .id("/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/devices/testDevice")
 *                 .build())
 *             .location("eastus")
 *             .managedApplicationParameters()
 *             .networkFunctionName("testNf")
 *             .networkFunctionUserConfigurations(NetworkFunctionUserConfigurationArgs.builder()
 *                 .networkInterfaces(
 *                     NetworkInterfaceArgs.builder()
 *                         .ipConfigurations(NetworkInterfaceIPConfigurationArgs.builder()
 *                             .gateway("")
 *                             .ipAddress("")
 *                             .ipAllocationMethod("Dynamic")
 *                             .ipVersion("IPv4")
 *                             .subnet("")
 *                             .build())
 *                         .macAddress("")
 *                         .networkInterfaceName("nic1")
 *                         .vmSwitchType("Management")
 *                         .build(),
 *                     NetworkInterfaceArgs.builder()
 *                         .ipConfigurations(NetworkInterfaceIPConfigurationArgs.builder()
 *                             .gateway("")
 *                             .ipAddress("")
 *                             .ipAllocationMethod("Dynamic")
 *                             .ipVersion("IPv4")
 *                             .subnet("")
 *                             .build())
 *                         .macAddress("DC-97-F8-79-16-7D")
 *                         .networkInterfaceName("nic2")
 *                         .vmSwitchType("Wan")
 *                         .build())
 *                 .roleName("testRole")
 *                 .userDataParameters()
 *                 .build())
 *             .resourceGroupName("rg")
 *             .skuName("testSku")
 *             .vendorName("testVendor")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:NetworkFunction testNf /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/networkFunctions/{networkFunctionName}
 * ```
 * @property device The reference to the device resource. Once set, it cannot be updated.
 * @property location The geo-location where the resource lives
 * @property managedApplicationParameters The parameters for the managed application.
 * @property networkFunctionContainerConfigurations The network function container configurations from the user.
 * @property networkFunctionName Resource name for the network function resource.
 * @property networkFunctionUserConfigurations The network function configurations from the user.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property skuName The sku name for the network function. Once set, it cannot be updated.
 * @property tags Resource tags.
 * @property vendorName The vendor name for the network function. Once set, it cannot be updated.
 */
public data class NetworkFunctionArgs(
    public val device: Output<SubResourceArgs>? = null,
    public val location: Output<String>? = null,
    public val managedApplicationParameters: Output<Any>? = null,
    public val networkFunctionContainerConfigurations: Output<Any>? = null,
    public val networkFunctionName: Output<String>? = null,
    public val networkFunctionUserConfigurations: Output<List<NetworkFunctionUserConfigurationArgs>>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val skuName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vendorName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.NetworkFunctionArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.NetworkFunctionArgs =
        com.pulumi.azurenative.hybridnetwork.NetworkFunctionArgs.builder()
            .device(device?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedApplicationParameters(managedApplicationParameters?.applyValue({ args0 -> args0 }))
            .networkFunctionContainerConfigurations(
                networkFunctionContainerConfigurations?.applyValue({ args0 ->
                    args0
                }),
            )
            .networkFunctionName(networkFunctionName?.applyValue({ args0 -> args0 }))
            .networkFunctionUserConfigurations(
                networkFunctionUserConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .skuName(skuName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vendorName(vendorName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkFunctionArgs].
 */
@PulumiTagMarker
public class NetworkFunctionArgsBuilder internal constructor() {
    private var device: Output<SubResourceArgs>? = null

    private var location: Output<String>? = null

    private var managedApplicationParameters: Output<Any>? = null

    private var networkFunctionContainerConfigurations: Output<Any>? = null

    private var networkFunctionName: Output<String>? = null

    private var networkFunctionUserConfigurations: Output<List<NetworkFunctionUserConfigurationArgs>>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var skuName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vendorName: Output<String>? = null

    /**
     * @param value The reference to the device resource. Once set, it cannot be updated.
     */
    @JvmName("frysrvxtmhhowiqi")
    public suspend fun device(`value`: Output<SubResourceArgs>) {
        this.device = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("nyfletehotjojjxp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The parameters for the managed application.
     */
    @JvmName("dedexptxlwofpyvh")
    public suspend fun managedApplicationParameters(`value`: Output<Any>) {
        this.managedApplicationParameters = value
    }

    /**
     * @param value The network function container configurations from the user.
     */
    @JvmName("fitmatcgtirkeioj")
    public suspend fun networkFunctionContainerConfigurations(`value`: Output<Any>) {
        this.networkFunctionContainerConfigurations = value
    }

    /**
     * @param value Resource name for the network function resource.
     */
    @JvmName("neuarcacaunmtkdg")
    public suspend fun networkFunctionName(`value`: Output<String>) {
        this.networkFunctionName = value
    }

    /**
     * @param value The network function configurations from the user.
     */
    @JvmName("axlnovhsiucaailg")
    public suspend fun networkFunctionUserConfigurations(`value`: Output<List<NetworkFunctionUserConfigurationArgs>>) {
        this.networkFunctionUserConfigurations = value
    }

    @JvmName("goxnjwftsoigidms")
    public suspend fun networkFunctionUserConfigurations(vararg values: Output<NetworkFunctionUserConfigurationArgs>) {
        this.networkFunctionUserConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The network function configurations from the user.
     */
    @JvmName("yagygdnhaniqudit")
    public suspend fun networkFunctionUserConfigurations(values: List<Output<NetworkFunctionUserConfigurationArgs>>) {
        this.networkFunctionUserConfigurations = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uumlvpdwsjbeuwjx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The sku name for the network function. Once set, it cannot be updated.
     */
    @JvmName("oqxfdjchnhkuhtge")
    public suspend fun skuName(`value`: Output<String>) {
        this.skuName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ffxuvsueyqwydsck")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The vendor name for the network function. Once set, it cannot be updated.
     */
    @JvmName("rbuhiidjklhugumf")
    public suspend fun vendorName(`value`: Output<String>) {
        this.vendorName = value
    }

    /**
     * @param value The reference to the device resource. Once set, it cannot be updated.
     */
    @JvmName("muajrkihbmrqtmkc")
    public suspend fun device(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.device = mapped
    }

    /**
     * @param argument The reference to the device resource. Once set, it cannot be updated.
     */
    @JvmName("ylpxdvmjwgtyefxm")
    public suspend fun device(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.device = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ofmtaiscuawtsvsd")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The parameters for the managed application.
     */
    @JvmName("qhoiggiesaujrfmn")
    public suspend fun managedApplicationParameters(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedApplicationParameters = mapped
    }

    /**
     * @param value The network function container configurations from the user.
     */
    @JvmName("llkkyqmhttdehewa")
    public suspend fun networkFunctionContainerConfigurations(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFunctionContainerConfigurations = mapped
    }

    /**
     * @param value Resource name for the network function resource.
     */
    @JvmName("wnocfokfkoluusmo")
    public suspend fun networkFunctionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFunctionName = mapped
    }

    /**
     * @param value The network function configurations from the user.
     */
    @JvmName("ottgqxqdjqmqjylx")
    public suspend fun networkFunctionUserConfigurations(`value`: List<NetworkFunctionUserConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFunctionUserConfigurations = mapped
    }

    /**
     * @param argument The network function configurations from the user.
     */
    @JvmName("mvsfgxfphrtugcyi")
    public suspend fun networkFunctionUserConfigurations(argument: List<suspend NetworkFunctionUserConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkFunctionUserConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkFunctionUserConfigurations = mapped
    }

    /**
     * @param argument The network function configurations from the user.
     */
    @JvmName("petrqwwyscdnfyob")
    public suspend fun networkFunctionUserConfigurations(vararg argument: suspend NetworkFunctionUserConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NetworkFunctionUserConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkFunctionUserConfigurations = mapped
    }

    /**
     * @param argument The network function configurations from the user.
     */
    @JvmName("lvnlbvfeborsdjjw")
    public suspend fun networkFunctionUserConfigurations(argument: suspend NetworkFunctionUserConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NetworkFunctionUserConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkFunctionUserConfigurations = mapped
    }

    /**
     * @param values The network function configurations from the user.
     */
    @JvmName("vjdmailjpnjyhnmh")
    public suspend fun networkFunctionUserConfigurations(vararg values: NetworkFunctionUserConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkFunctionUserConfigurations = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bqcibkycntvmqbay")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The sku name for the network function. Once set, it cannot be updated.
     */
    @JvmName("mitwqwvvwocmudbi")
    public suspend fun skuName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skuName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("buardhcfbnhawnsq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("lwttccbcwivqeeug")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The vendor name for the network function. Once set, it cannot be updated.
     */
    @JvmName("aqxwbehcyiqdccof")
    public suspend fun vendorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vendorName = mapped
    }

    internal fun build(): NetworkFunctionArgs = NetworkFunctionArgs(
        device = device,
        location = location,
        managedApplicationParameters = managedApplicationParameters,
        networkFunctionContainerConfigurations = networkFunctionContainerConfigurations,
        networkFunctionName = networkFunctionName,
        networkFunctionUserConfigurations = networkFunctionUserConfigurations,
        resourceGroupName = resourceGroupName,
        skuName = skuName,
        tags = tags,
        vendorName = vendorName,
    )
}
