@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.SiteNetworkServiceArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.SiteNetworkServicePropertiesFormatArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.SiteNetworkServicePropertiesFormatArgsBuilder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Site network service resource.
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### Create first party site network service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var siteNetworkService = new AzureNative.HybridNetwork.SiteNetworkService("siteNetworkService", new()
 *     {
 *         Location = "westUs2",
 *         Properties = new AzureNative.HybridNetwork.Inputs.SiteNetworkServicePropertiesFormatArgs
 *         {
 *             DesiredStateConfigurationGroupValueReferences =
 *             {
 *                 { "MyVM_Configuration", new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/configurationgroupvalues/MyVM_Configuration1",
 *                 } },
 *             },
 *             NetworkServiceDesignVersionResourceReference = new AzureNative.HybridNetwork.Inputs.SecretDeploymentResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/networkServiceDesignGroups/TestNetworkServiceDesignGroupName/networkServiceDesignVersions/1.0.0",
 *                 IdType = "Secret",
 *             },
 *             SiteReference = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/sites/testSite",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         SiteNetworkServiceName = "testSiteNetworkServiceName",
 *         Sku = new AzureNative.HybridNetwork.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.HybridNetwork.SkuName.Standard,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewSiteNetworkService(ctx, "siteNetworkService", &hybridnetwork.SiteNetworkServiceArgs{
 * 			Location: pulumi.String("westUs2"),
 * 			Properties: &hybridnetwork.SiteNetworkServicePropertiesFormatArgs{
 * 				DesiredStateConfigurationGroupValueReferences: hybridnetwork.ReferencedResourceMap{
 * 					"MyVM_Configuration": &hybridnetwork.ReferencedResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/configurationgroupvalues/MyVM_Configuration1"),
 * 					},
 * 				},
 * 				NetworkServiceDesignVersionResourceReference: hybridnetwork.SecretDeploymentResourceReference{
 * 					Id:     "/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/networkServiceDesignGroups/TestNetworkServiceDesignGroupName/networkServiceDesignVersions/1.0.0",
 * 					IdType: "Secret",
 * 				},
 * 				SiteReference: &hybridnetwork.ReferencedResourceArgs{
 * 					Id: pulumi.String("/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/sites/testSite"),
 * 				},
 * 			},
 * 			ResourceGroupName:      pulumi.String("rg1"),
 * 			SiteNetworkServiceName: pulumi.String("testSiteNetworkServiceName"),
 * 			Sku: &hybridnetwork.SkuArgs{
 * 				Name: pulumi.String(hybridnetwork.SkuNameStandard),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.SiteNetworkService;
 * import com.pulumi.azurenative.hybridnetwork.SiteNetworkServiceArgs;
 * import com.pulumi.azurenative.hybridnetwork.inputs.SiteNetworkServicePropertiesFormatArgs;
 * import com.pulumi.azurenative.hybridnetwork.inputs.ReferencedResourceArgs;
 * import com.pulumi.azurenative.hybridnetwork.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var siteNetworkService = new SiteNetworkService("siteNetworkService", SiteNetworkServiceArgs.builder()
 *             .location("westUs2")
 *             .properties(SiteNetworkServicePropertiesFormatArgs.builder()
 *                 .desiredStateConfigurationGroupValueReferences(Map.of("MyVM_Configuration", Map.of("id", "/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/configurationgroupvalues/MyVM_Configuration1")))
 *                 .networkServiceDesignVersionResourceReference(SecretDeploymentResourceReferenceArgs.builder()
 *                     .id("/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/networkServiceDesignGroups/TestNetworkServiceDesignGroupName/networkServiceDesignVersions/1.0.0")
 *                     .idType("Secret")
 *                     .build())
 *                 .siteReference(ReferencedResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/sites/testSite")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .siteNetworkServiceName("testSiteNetworkServiceName")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create site network service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var siteNetworkService = new AzureNative.HybridNetwork.SiteNetworkService("siteNetworkService", new()
 *     {
 *         Location = "westUs2",
 *         Properties = new AzureNative.HybridNetwork.Inputs.SiteNetworkServicePropertiesFormatArgs
 *         {
 *             DesiredStateConfigurationGroupValueReferences =
 *             {
 *                 { "MyVM_Configuration", new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/configurationgroupvalues/MyVM_Configuration1",
 *                 } },
 *             },
 *             NetworkServiceDesignVersionResourceReference = new AzureNative.HybridNetwork.Inputs.OpenDeploymentResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/networkServiceDesignGroups/TestNetworkServiceDesignGroupName/networkServiceDesignVersions/1.0.0",
 *                 IdType = "Open",
 *             },
 *             SiteReference = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/sites/testSite",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         SiteNetworkServiceName = "testSiteNetworkServiceName",
 *         Sku = new AzureNative.HybridNetwork.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.HybridNetwork.SkuName.Standard,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewSiteNetworkService(ctx, "siteNetworkService", &hybridnetwork.SiteNetworkServiceArgs{
 * 			Location: pulumi.String("westUs2"),
 * 			Properties: &hybridnetwork.SiteNetworkServicePropertiesFormatArgs{
 * 				DesiredStateConfigurationGroupValueReferences: hybridnetwork.ReferencedResourceMap{
 * 					"MyVM_Configuration": &hybridnetwork.ReferencedResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/configurationgroupvalues/MyVM_Configuration1"),
 * 					},
 * 				},
 * 				NetworkServiceDesignVersionResourceReference: hybridnetwork.OpenDeploymentResourceReference{
 * 					Id:     "/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/networkServiceDesignGroups/TestNetworkServiceDesignGroupName/networkServiceDesignVersions/1.0.0",
 * 					IdType: "Open",
 * 				},
 * 				SiteReference: &hybridnetwork.ReferencedResourceArgs{
 * 					Id: pulumi.String("/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/sites/testSite"),
 * 				},
 * 			},
 * 			ResourceGroupName:      pulumi.String("rg1"),
 * 			SiteNetworkServiceName: pulumi.String("testSiteNetworkServiceName"),
 * 			Sku: &hybridnetwork.SkuArgs{
 * 				Name: pulumi.String(hybridnetwork.SkuNameStandard),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.SiteNetworkService;
 * import com.pulumi.azurenative.hybridnetwork.SiteNetworkServiceArgs;
 * import com.pulumi.azurenative.hybridnetwork.inputs.SiteNetworkServicePropertiesFormatArgs;
 * import com.pulumi.azurenative.hybridnetwork.inputs.ReferencedResourceArgs;
 * import com.pulumi.azurenative.hybridnetwork.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var siteNetworkService = new SiteNetworkService("siteNetworkService", SiteNetworkServiceArgs.builder()
 *             .location("westUs2")
 *             .properties(SiteNetworkServicePropertiesFormatArgs.builder()
 *                 .desiredStateConfigurationGroupValueReferences(Map.of("MyVM_Configuration", Map.of("id", "/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/configurationgroupvalues/MyVM_Configuration1")))
 *                 .networkServiceDesignVersionResourceReference(OpenDeploymentResourceReferenceArgs.builder()
 *                     .id("/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/networkServiceDesignGroups/TestNetworkServiceDesignGroupName/networkServiceDesignVersions/1.0.0")
 *                     .idType("Open")
 *                     .build())
 *                 .siteReference(ReferencedResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/sites/testSite")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .siteNetworkServiceName("testSiteNetworkServiceName")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:SiteNetworkService testSiteNetworkServiceName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/siteNetworkServices/{siteNetworkServiceName}
 * ```
 * @property identity The managed identity of the Site network service, if configured.
 * @property location The geo-location where the resource lives
 * @property properties Site network service properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteNetworkServiceName The name of the site network service.
 * @property sku Sku of the site network service.
 * @property tags Resource tags.
 */
public data class SiteNetworkServiceArgs(
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<SiteNetworkServicePropertiesFormatArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val siteNetworkServiceName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.SiteNetworkServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.SiteNetworkServiceArgs =
        com.pulumi.azurenative.hybridnetwork.SiteNetworkServiceArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteNetworkServiceName(siteNetworkServiceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SiteNetworkServiceArgs].
 */
@PulumiTagMarker
public class SiteNetworkServiceArgsBuilder internal constructor() {
    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var properties: Output<SiteNetworkServicePropertiesFormatArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var siteNetworkServiceName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The managed identity of the Site network service, if configured.
     */
    @JvmName("anfgcpbaqqyfnrgl")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("twqxrbcebqbpgkja")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Site network service properties.
     */
    @JvmName("vkogcdlcnaohsqgs")
    public suspend fun properties(`value`: Output<SiteNetworkServicePropertiesFormatArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yqexkspnqwnydhxs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the site network service.
     */
    @JvmName("kjnlujvmiwnutjeg")
    public suspend fun siteNetworkServiceName(`value`: Output<String>) {
        this.siteNetworkServiceName = value
    }

    /**
     * @param value Sku of the site network service.
     */
    @JvmName("ohytmdudljxfrxfn")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("onbctrwuxypmfqwh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The managed identity of the Site network service, if configured.
     */
    @JvmName("orqbykqrtkovwxtg")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed identity of the Site network service, if configured.
     */
    @JvmName("neladlwbhoklcguy")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("awitnylpdefyyvuw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Site network service properties.
     */
    @JvmName("jvlopyieveecmnwp")
    public suspend fun properties(`value`: SiteNetworkServicePropertiesFormatArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Site network service properties.
     */
    @JvmName("djvtyhtdixbejrpa")
    public suspend fun properties(argument: suspend SiteNetworkServicePropertiesFormatArgsBuilder.() -> Unit) {
        val toBeMapped = SiteNetworkServicePropertiesFormatArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wmwlxprtyvjitjij")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the site network service.
     */
    @JvmName("mmqvbserhdevrmxg")
    public suspend fun siteNetworkServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteNetworkServiceName = mapped
    }

    /**
     * @param value Sku of the site network service.
     */
    @JvmName("aeitvmtjlqaxqrbq")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Sku of the site network service.
     */
    @JvmName("wjovlqiwkvsympic")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wglhhmxuqpkoijot")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ainshiuqcgfumctb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SiteNetworkServiceArgs = SiteNetworkServiceArgs(
        identity = identity,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        siteNetworkServiceName = siteNetworkServiceName,
        sku = sku,
        tags = tags,
    )
}
