@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.VendorSkuPreviewArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Customer subscription which can use a sku.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2020-01-01-preview.
 * ## Example Usage
 * ### Create or update preview subscription of vendor sku sub resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vendorSkuPreview = new AzureNative.HybridNetwork.VendorSkuPreview("vendorSkuPreview", new()
 *     {
 *         PreviewSubscription = "previewSub",
 *         SkuName = "TestSku",
 *         VendorName = "TestVendor",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewVendorSkuPreview(ctx, "vendorSkuPreview", &hybridnetwork.VendorSkuPreviewArgs{
 * 			PreviewSubscription: pulumi.String("previewSub"),
 * 			SkuName:             pulumi.String("TestSku"),
 * 			VendorName:          pulumi.String("TestVendor"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.VendorSkuPreview;
 * import com.pulumi.azurenative.hybridnetwork.VendorSkuPreviewArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vendorSkuPreview = new VendorSkuPreview("vendorSkuPreview", VendorSkuPreviewArgs.builder()
 *             .previewSubscription("previewSub")
 *             .skuName("TestSku")
 *             .vendorName("TestVendor")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:VendorSkuPreview previewSub /subscriptions/{subscriptionId}/providers/Microsoft.HybridNetwork/vendors/{vendorName}/vendorSkus/{skuName}/previewSubscriptions/{previewSubscription}
 * ```
 * @property previewSubscription Preview subscription ID.
 * @property skuName The name of the vendor sku.
 * @property vendorName The name of the vendor.
 */
public data class VendorSkuPreviewArgs(
    public val previewSubscription: Output<String>? = null,
    public val skuName: Output<String>? = null,
    public val vendorName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.VendorSkuPreviewArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.VendorSkuPreviewArgs =
        com.pulumi.azurenative.hybridnetwork.VendorSkuPreviewArgs.builder()
            .previewSubscription(previewSubscription?.applyValue({ args0 -> args0 }))
            .skuName(skuName?.applyValue({ args0 -> args0 }))
            .vendorName(vendorName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VendorSkuPreviewArgs].
 */
@PulumiTagMarker
public class VendorSkuPreviewArgsBuilder internal constructor() {
    private var previewSubscription: Output<String>? = null

    private var skuName: Output<String>? = null

    private var vendorName: Output<String>? = null

    /**
     * @param value Preview subscription ID.
     */
    @JvmName("dnrlqydkksngjrax")
    public suspend fun previewSubscription(`value`: Output<String>) {
        this.previewSubscription = value
    }

    /**
     * @param value The name of the vendor sku.
     */
    @JvmName("xfkmdhrehkcmwxrh")
    public suspend fun skuName(`value`: Output<String>) {
        this.skuName = value
    }

    /**
     * @param value The name of the vendor.
     */
    @JvmName("qdqhahyibtlcmytt")
    public suspend fun vendorName(`value`: Output<String>) {
        this.vendorName = value
    }

    /**
     * @param value Preview subscription ID.
     */
    @JvmName("lkcvddrbatrdbyau")
    public suspend fun previewSubscription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.previewSubscription = mapped
    }

    /**
     * @param value The name of the vendor sku.
     */
    @JvmName("dbwqxxwgpywwkuyv")
    public suspend fun skuName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skuName = mapped
    }

    /**
     * @param value The name of the vendor.
     */
    @JvmName("quxbnhptpcokwocv")
    public suspend fun vendorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vendorName = mapped
    }

    internal fun build(): VendorSkuPreviewArgs = VendorSkuPreviewArgs(
        previewSubscription = previewSubscription,
        skuName = skuName,
        vendorName = vendorName,
    )
}
