@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.NetworkFunctionTemplateResponse
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.NetworkFunctionTemplateResponse.Companion.toKotlin as networkFunctionTemplateResponseToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [VendorSkus].
 */
@PulumiTagMarker
public class VendorSkusResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VendorSkusArgs = VendorSkusArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VendorSkusArgsBuilder.() -> Unit) {
        val builder = VendorSkusArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VendorSkus {
        val builtJavaResource = com.pulumi.azurenative.hybridnetwork.VendorSkus(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VendorSkus(builtJavaResource)
    }
}

/**
 * Sku sub resource.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2020-01-01-preview.
 * ## Example Usage
 * ### Create or update the sku of vendor resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vendorSkus = new AzureNative.HybridNetwork.VendorSkus("vendorSkus", new()
 *     {
 *         DeploymentMode = AzureNative.HybridNetwork.SkuDeploymentMode.PrivateEdgeZone,
 *         ManagedApplicationTemplate = null,
 *         NetworkFunctionTemplate = new AzureNative.HybridNetwork.Inputs.NetworkFunctionTemplateArgs
 *         {
 *             NetworkFunctionRoleConfigurations = new[]
 *             {
 *                 new AzureNative.HybridNetwork.Inputs.NetworkFunctionRoleConfigurationArgs
 *                 {
 *                     CustomProfile = new AzureNative.HybridNetwork.Inputs.CustomProfileArgs
 *                     {
 *                         MetadataConfigurationPath = "/var/logs/network.cfg",
 *                     },
 *                     NetworkInterfaces = new[]
 *                     {
 *                         new AzureNative.HybridNetwork.Inputs.NetworkInterfaceArgs
 *                         {
 *                             IpConfigurations = new[]
 *                             {
 *                                 new AzureNative.HybridNetwork.Inputs.NetworkInterfaceIPConfigurationArgs
 *                                 {
 *                                     Gateway = "",
 *                                     IpAddress = "",
 *                                     IpAllocationMethod = AzureNative.HybridNetwork.IPAllocationMethod.Dynamic,
 *                                     IpVersion = AzureNative.HybridNetwork.IPVersion.IPv4,
 *                                     Subnet = "",
 *                                 },
 *                             },
 *                             MacAddress = "",
 *                             NetworkInterfaceName = "nic1",
 *                             VmSwitchType = AzureNative.HybridNetwork.VMSwitchType.Wan,
 *                         },
 *                         new AzureNative.HybridNetwork.Inputs.NetworkInterfaceArgs
 *                         {
 *                             IpConfigurations = new[]
 *                             {
 *                                 new AzureNative.HybridNetwork.Inputs.NetworkInterfaceIPConfigurationArgs
 *                                 {
 *                                     Gateway = "",
 *                                     IpAddress = "",
 *                                     IpAllocationMethod = AzureNative.HybridNetwork.IPAllocationMethod.Dynamic,
 *                                     IpVersion = AzureNative.HybridNetwork.IPVersion.IPv4,
 *                                     Subnet = "",
 *                                 },
 *                             },
 *                             MacAddress = "",
 *                             NetworkInterfaceName = "nic2",
 *                             VmSwitchType = AzureNative.HybridNetwork.VMSwitchType.Management,
 *                         },
 *                     },
 *                     OsProfile = new AzureNative.HybridNetwork.Inputs.OsProfileArgs
 *                     {
 *                         AdminUsername = "dummyuser",
 *                         CustomData = "base-64 encoded string of custom data",
 *                         LinuxConfiguration = new AzureNative.HybridNetwork.Inputs.LinuxConfigurationArgs
 *                         {
 *                             Ssh = new AzureNative.HybridNetwork.Inputs.SshConfigurationArgs
 *                             {
 *                                 PublicKeys = new[]
 *                                 {
 *                                     new AzureNative.HybridNetwork.Inputs.SshPublicKeyArgs
 *                                     {
 *                                         KeyData = "ssh-rsa AAAAB3NzaC1yc2EAAAABIwAAAgEAwrr66r8n6B8Y0zMF3dOpXEapIQD9DiYQ6D6/zwor9o39jSkHNiMMER/GETBbzP83LOcekm02aRjo55ArO7gPPVvCXbrirJu9pkm4AC4BBre5xSLS= user@constoso-DSH",
 *                                         Path = "home/user/.ssh/authorized_keys",
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     RoleName = "test",
 *                     RoleType = AzureNative.HybridNetwork.NetworkFunctionRoleConfigurationType.VirtualMachine,
 *                     StorageProfile = new AzureNative.HybridNetwork.Inputs.StorageProfileArgs
 *                     {
 *                         DataDisks = new[]
 *                         {
 *                             new AzureNative.HybridNetwork.Inputs.DataDiskArgs
 *                             {
 *                                 CreateOption = AzureNative.HybridNetwork.DiskCreateOptionTypes.Empty,
 *                                 DiskSizeGB = 10,
 *                                 Name = "DataDisk1",
 *                             },
 *                         },
 *                         ImageReference = new AzureNative.HybridNetwork.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "UbuntuServer",
 *                             Publisher = "Canonical",
 *                             Sku = "18.04-LTS",
 *                             Version = "18.04.201804262",
 *                         },
 *                         OsDisk = new AzureNative.HybridNetwork.Inputs.OsDiskArgs
 *                         {
 *                             DiskSizeGB = 30,
 *                             Name = "vhdName",
 *                             OsType = AzureNative.HybridNetwork.OperatingSystemTypes.Linux,
 *                             Vhd = new AzureNative.HybridNetwork.Inputs.VirtualHardDiskArgs
 *                             {
 *                                 Uri = "https://contoso.net/link/vnd.vhd?sp=rl&st=2020-10-08T20:38:19Z&se=2020-12-09T19:38:00Z&sv=2019-12-12&sr=b&sig=7BM2f4yOw%3D",
 *                             },
 *                         },
 *                     },
 *                     VirtualMachineSize = AzureNative.HybridNetwork.VirtualMachineSizeTypes.Standard_D3_v2,
 *                 },
 *             },
 *         },
 *         NetworkFunctionType = AzureNative.HybridNetwork.NetworkFunctionType.VirtualNetworkFunction,
 *         Preview = true,
 *         SkuName = "TestSku",
 *         VendorName = "TestVendor",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewVendorSkus(ctx, "vendorSkus", &hybridnetwork.VendorSkusArgs{
 * 			DeploymentMode:             pulumi.String(hybridnetwork.SkuDeploymentModePrivateEdgeZone),
 * 			ManagedApplicationTemplate: pulumi.Any(nil),
 * 			NetworkFunctionTemplate: &hybridnetwork.NetworkFunctionTemplateArgs{
 * 				NetworkFunctionRoleConfigurations: hybridnetwork.NetworkFunctionRoleConfigurationArray{
 * 					&hybridnetwork.NetworkFunctionRoleConfigurationArgs{
 * 						CustomProfile: &hybridnetwork.CustomProfileArgs{
 * 							MetadataConfigurationPath: pulumi.String("/var/logs/network.cfg"),
 * 						},
 * 						NetworkInterfaces: hybridnetwork.NetworkInterfaceArray{
 * 							&hybridnetwork.NetworkInterfaceArgs{
 * 								IpConfigurations: hybridnetwork.NetworkInterfaceIPConfigurationArray{
 * 									&hybridnetwork.NetworkInterfaceIPConfigurationArgs{
 * 										Gateway:            pulumi.String(""),
 * 										IpAddress:          pulumi.String(""),
 * 										IpAllocationMethod: pulumi.String(hybridnetwork.IPAllocationMethodDynamic),
 * 										IpVersion:          pulumi.String(hybridnetwork.IPVersionIPv4),
 * 										Subnet:             pulumi.String(""),
 * 									},
 * 								},
 * 								MacAddress:           pulumi.String(""),
 * 								NetworkInterfaceName: pulumi.String("nic1"),
 * 								VmSwitchType:         pulumi.String(hybridnetwork.VMSwitchTypeWan),
 * 							},
 * 							&hybridnetwork.NetworkInterfaceArgs{
 * 								IpConfigurations: hybridnetwork.NetworkInterfaceIPConfigurationArray{
 * 									&hybridnetwork.NetworkInterfaceIPConfigurationArgs{
 * 										Gateway:            pulumi.String(""),
 * 										IpAddress:          pulumi.String(""),
 * 										IpAllocationMethod: pulumi.String(hybridnetwork.IPAllocationMethodDynamic),
 * 										IpVersion:          pulumi.String(hybridnetwork.IPVersionIPv4),
 * 										Subnet:             pulumi.String(""),
 * 									},
 * 								},
 * 								MacAddress:           pulumi.String(""),
 * 								NetworkInterfaceName: pulumi.String("nic2"),
 * 								VmSwitchType:         pulumi.String(hybridnetwork.VMSwitchTypeManagement),
 * 							},
 * 						},
 * 						OsProfile: &hybridnetwork.OsProfileArgs{
 * 							AdminUsername: pulumi.String("dummyuser"),
 * 							CustomData:    pulumi.String("base-64 encoded string of custom data"),
 * 							LinuxConfiguration: &hybridnetwork.LinuxConfigurationArgs{
 * 								Ssh: &hybridnetwork.SshConfigurationArgs{
 * 									PublicKeys: hybridnetwork.SshPublicKeyArray{
 * 										&hybridnetwork.SshPublicKeyArgs{
 * 											KeyData: pulumi.String("ssh-rsa AAAAB3NzaC1yc2EAAAABIwAAAgEAwrr66r8n6B8Y0zMF3dOpXEapIQD9DiYQ6D6/zwor9o39jSkHNiMMER/GETBbzP83LOcekm02aRjo55ArO7gPPVvCXbrirJu9pkm4AC4BBre5xSLS= user@constoso-DSH"),
 * 											Path:    pulumi.String("home/user/.ssh/authorized_keys"),
 * 										},
 * 									},
 * 								},
 * 							},
 * 						},
 * 						RoleName: pulumi.String("test"),
 * 						RoleType: pulumi.String(hybridnetwork.NetworkFunctionRoleConfigurationTypeVirtualMachine),
 * 						StorageProfile: &hybridnetwork.StorageProfileArgs{
 * 							DataDisks: hybridnetwork.DataDiskArray{
 * 								&hybridnetwork.DataDiskArgs{
 * 									CreateOption: pulumi.String(hybridnetwork.DiskCreateOptionTypesEmpty),
 * 									DiskSizeGB:   pulumi.Int(10),
 * 									Name:         pulumi.String("DataDisk1"),
 * 								},
 * 							},
 * 							ImageReference: &hybridnetwork.ImageReferenceArgs{
 * 								Offer:     pulumi.String("UbuntuServer"),
 * 								Publisher: pulumi.String("Canonical"),
 * 								Sku:       pulumi.String("18.04-LTS"),
 * 								Version:   pulumi.String("18.04.201804262"),
 * 							},
 * 							OsDisk: &hybridnetwork.OsDiskArgs{
 * 								DiskSizeGB: pulumi.Int(30),
 * 								Name:       pulumi.String("vhdName"),
 * 								OsType:     pulumi.String(hybridnetwork.OperatingSystemTypesLinux),
 * 								Vhd: &hybridnetwork.VirtualHardDiskArgs{
 * 									Uri: pulumi.String("https://contoso.net/link/vnd.vhd?sp=rl&st=2020-10-08T20:38:19Z&se=2020-12-09T19:38:00Z&sv=2019-12-12&sr=b&sig=7BM2f4yOw%3D"),
 * 								},
 * 							},
 * 						},
 * 						VirtualMachineSize: pulumi.String(hybridnetwork.VirtualMachineSizeTypes_Standard_D3_v2),
 * 					},
 * 				},
 * 			},
 * 			NetworkFunctionType: pulumi.String(hybridnetwork.NetworkFunctionTypeVirtualNetworkFunction),
 * 			Preview:             pulumi.Bool(true),
 * 			SkuName:             pulumi.String("TestSku"),
 * 			VendorName:          pulumi.String("TestVendor"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.VendorSkus;
 * import com.pulumi.azurenative.hybridnetwork.VendorSkusArgs;
 * import com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vendorSkus = new VendorSkus("vendorSkus", VendorSkusArgs.builder()
 *             .deploymentMode("PrivateEdgeZone")
 *             .managedApplicationTemplate()
 *             .networkFunctionTemplate(NetworkFunctionTemplateArgs.builder()
 *                 .networkFunctionRoleConfigurations(NetworkFunctionRoleConfigurationArgs.builder()
 *                     .customProfile(CustomProfileArgs.builder()
 *                         .metadataConfigurationPath("/var/logs/network.cfg")
 *                         .build())
 *                     .networkInterfaces(
 *                         NetworkInterfaceArgs.builder()
 *                             .ipConfigurations(NetworkInterfaceIPConfigurationArgs.builder()
 *                                 .gateway("")
 *                                 .ipAddress("")
 *                                 .ipAllocationMethod("Dynamic")
 *                                 .ipVersion("IPv4")
 *                                 .subnet("")
 *                                 .build())
 *                             .macAddress("")
 *                             .networkInterfaceName("nic1")
 *                             .vmSwitchType("Wan")
 *                             .build(),
 *                         NetworkInterfaceArgs.builder()
 *                             .ipConfigurations(NetworkInterfaceIPConfigurationArgs.builder()
 *                                 .gateway("")
 *                                 .ipAddress("")
 *                                 .ipAllocationMethod("Dynamic")
 *                                 .ipVersion("IPv4")
 *                                 .subnet("")
 *                                 .build())
 *                             .macAddress("")
 *                             .networkInterfaceName("nic2")
 *                             .vmSwitchType("Management")
 *                             .build())
 *                     .osProfile(OsProfileArgs.builder()
 *                         .adminUsername("dummyuser")
 *                         .customData("base-64 encoded string of custom data")
 *                         .linuxConfiguration(LinuxConfigurationArgs.builder()
 *                             .ssh(SshConfigurationArgs.builder()
 *                                 .publicKeys(SshPublicKeyArgs.builder()
 *                                     .keyData("ssh-rsa AAAAB3NzaC1yc2EAAAABIwAAAgEAwrr66r8n6B8Y0zMF3dOpXEapIQD9DiYQ6D6/zwor9o39jSkHNiMMER/GETBbzP83LOcekm02aRjo55ArO7gPPVvCXbrirJu9pkm4AC4BBre5xSLS= user@constoso-DSH")
 *                                     .path("home/user/.ssh/authorized_keys")
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .roleName("test")
 *                     .roleType("VirtualMachine")
 *                     .storageProfile(StorageProfileArgs.builder()
 *                         .dataDisks(DataDiskArgs.builder()
 *                             .createOption("Empty")
 *                             .diskSizeGB(10)
 *                             .name("DataDisk1")
 *                             .build())
 *                         .imageReference(ImageReferenceArgs.builder()
 *                             .offer("UbuntuServer")
 *                             .publisher("Canonical")
 *                             .sku("18.04-LTS")
 *                             .version("18.04.201804262")
 *                             .build())
 *                         .osDisk(OsDiskArgs.builder()
 *                             .diskSizeGB(30)
 *                             .name("vhdName")
 *                             .osType("Linux")
 *                             .vhd(VirtualHardDiskArgs.builder()
 *                                 .uri("https://contoso.net/link/vnd.vhd?sp=rl&st=2020-10-08T20:38:19Z&se=2020-12-09T19:38:00Z&sv=2019-12-12&sr=b&sig=7BM2f4yOw%3D")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .virtualMachineSize("Standard_D3_v2")
 *                     .build())
 *                 .build())
 *             .networkFunctionType("VirtualNetworkFunction")
 *             .preview(true)
 *             .skuName("TestSku")
 *             .vendorName("TestVendor")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:VendorSkus TestSku /subscriptions/{subscriptionId}/providers/Microsoft.HybridNetwork/vendors/{vendorName}/vendorSkus/{skuName}
 * ```
 */
public class VendorSkus internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridnetwork.VendorSkus,
) : KotlinCustomResource(javaResource, VendorSkusMapper) {
    /**
     * The sku deployment mode.
     */
    public val deploymentMode: Output<String>?
        get() = javaResource.deploymentMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The parameters for the managed application to be supplied by the vendor.
     */
    public val managedApplicationParameters: Output<Any>?
        get() = javaResource.managedApplicationParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The template for the managed application deployment.
     */
    public val managedApplicationTemplate: Output<Any>?
        get() = javaResource.managedApplicationTemplate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The template definition of the network function.
     */
    public val networkFunctionTemplate: Output<NetworkFunctionTemplateResponse>?
        get() = javaResource.networkFunctionTemplate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkFunctionTemplateResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The network function type.
     */
    public val networkFunctionType: Output<String>?
        get() = javaResource.networkFunctionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates if the vendor sku is in preview mode.
     */
    public val preview: Output<Boolean>?
        get() = javaResource.preview().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of the vendor sku sub resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The sku type.
     */
    public val skuType: Output<String>?
        get() = javaResource.skuType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VendorSkusMapper : ResourceMapper<VendorSkus> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridnetwork.VendorSkus::class == javaResource::class

    override fun map(javaResource: Resource): VendorSkus = VendorSkus(
        javaResource as
            com.pulumi.azurenative.hybridnetwork.VendorSkus,
    )
}

/**
 * @see [VendorSkus].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VendorSkus].
 */
public suspend fun vendorSkus(name: String, block: suspend VendorSkusResourceBuilder.() -> Unit): VendorSkus {
    val builder = VendorSkusResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VendorSkus].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vendorSkus(name: String): VendorSkus {
    val builder = VendorSkusResourceBuilder()
    builder.name(name)
    return builder.build()
}
