@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.ArtifactManifestPropertiesFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Artifact manifest properties.
 * @property artifacts The artifacts list.
 */
public data class ArtifactManifestPropertiesFormatArgs(
    public val artifacts: Output<List<ManifestArtifactFormatArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.ArtifactManifestPropertiesFormatArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.ArtifactManifestPropertiesFormatArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.ArtifactManifestPropertiesFormatArgs.builder()
            .artifacts(
                artifacts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ArtifactManifestPropertiesFormatArgs].
 */
@PulumiTagMarker
public class ArtifactManifestPropertiesFormatArgsBuilder internal constructor() {
    private var artifacts: Output<List<ManifestArtifactFormatArgs>>? = null

    /**
     * @param value The artifacts list.
     */
    @JvmName("agbjxbwjwihcprgj")
    public suspend fun artifacts(`value`: Output<List<ManifestArtifactFormatArgs>>) {
        this.artifacts = value
    }

    @JvmName("kqofrowyochdrpyr")
    public suspend fun artifacts(vararg values: Output<ManifestArtifactFormatArgs>) {
        this.artifacts = Output.all(values.asList())
    }

    /**
     * @param values The artifacts list.
     */
    @JvmName("ednvptsfievokyin")
    public suspend fun artifacts(values: List<Output<ManifestArtifactFormatArgs>>) {
        this.artifacts = Output.all(values)
    }

    /**
     * @param value The artifacts list.
     */
    @JvmName("ckgigmgqbgbmljdf")
    public suspend fun artifacts(`value`: List<ManifestArtifactFormatArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifacts = mapped
    }

    /**
     * @param argument The artifacts list.
     */
    @JvmName("yctxucvvocsaktwu")
    public suspend fun artifacts(argument: List<suspend ManifestArtifactFormatArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManifestArtifactFormatArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.artifacts = mapped
    }

    /**
     * @param argument The artifacts list.
     */
    @JvmName("layoujsyvdehrcoq")
    public suspend fun artifacts(vararg argument: suspend ManifestArtifactFormatArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ManifestArtifactFormatArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.artifacts = mapped
    }

    /**
     * @param argument The artifacts list.
     */
    @JvmName("asncsxvlqgwhwxvs")
    public suspend fun artifacts(argument: suspend ManifestArtifactFormatArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ManifestArtifactFormatArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.artifacts = mapped
    }

    /**
     * @param values The artifacts list.
     */
    @JvmName("mdkqojypkejuolxu")
    public suspend fun artifacts(vararg values: ManifestArtifactFormatArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.artifacts = mapped
    }

    internal fun build(): ArtifactManifestPropertiesFormatArgs = ArtifactManifestPropertiesFormatArgs(
        artifacts = artifacts,
    )
}
