@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.ArtifactStorePropertiesFormatArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.enums.ArtifactReplicationStrategy
import com.pulumi.azurenative.hybridnetwork.kotlin.enums.ArtifactStoreType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Artifact store properties.
 * @property managedResourceGroupConfiguration
 * @property replicationStrategy The replication strategy.
 * @property storeType The artifact store type.
 */
public data class ArtifactStorePropertiesFormatArgs(
    public val managedResourceGroupConfiguration: Output<ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgs>? = null,
    public val replicationStrategy: Output<Either<String, ArtifactReplicationStrategy>>? = null,
    public val storeType: Output<Either<String, ArtifactStoreType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.ArtifactStorePropertiesFormatArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.ArtifactStorePropertiesFormatArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.ArtifactStorePropertiesFormatArgs.builder()
            .managedResourceGroupConfiguration(
                managedResourceGroupConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .replicationStrategy(
                replicationStrategy?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .storeType(
                storeType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ArtifactStorePropertiesFormatArgs].
 */
@PulumiTagMarker
public class ArtifactStorePropertiesFormatArgsBuilder internal constructor() {
    private var managedResourceGroupConfiguration:
        Output<ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgs>? = null

    private var replicationStrategy: Output<Either<String, ArtifactReplicationStrategy>>? = null

    private var storeType: Output<Either<String, ArtifactStoreType>>? = null

    /**
     * @param value
     */
    @JvmName("cfagxvoaotrnbcbk")
    public suspend fun managedResourceGroupConfiguration(`value`: Output<ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgs>) {
        this.managedResourceGroupConfiguration = value
    }

    /**
     * @param value The replication strategy.
     */
    @JvmName("atoauwlcdjoylfbj")
    public suspend fun replicationStrategy(`value`: Output<Either<String, ArtifactReplicationStrategy>>) {
        this.replicationStrategy = value
    }

    /**
     * @param value The artifact store type.
     */
    @JvmName("kgvbhldluehveptl")
    public suspend fun storeType(`value`: Output<Either<String, ArtifactStoreType>>) {
        this.storeType = value
    }

    /**
     * @param value
     */
    @JvmName("dtjbenbjgkcveqnx")
    public suspend fun managedResourceGroupConfiguration(`value`: ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedResourceGroupConfiguration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ysxliogtsrkiubgt")
    public suspend fun managedResourceGroupConfiguration(argument: suspend ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.managedResourceGroupConfiguration = mapped
    }

    /**
     * @param value The replication strategy.
     */
    @JvmName("bshkjuqcwqmeyaor")
    public suspend fun replicationStrategy(`value`: Either<String, ArtifactReplicationStrategy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationStrategy = mapped
    }

    /**
     * @param value The replication strategy.
     */
    @JvmName("dhdtdfpjmfksfxqn")
    public fun replicationStrategy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ArtifactReplicationStrategy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationStrategy = mapped
    }

    /**
     * @param value The replication strategy.
     */
    @JvmName("dwsncpwvbotywyca")
    public fun replicationStrategy(`value`: ArtifactReplicationStrategy) {
        val toBeMapped = Either.ofRight<String, ArtifactReplicationStrategy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationStrategy = mapped
    }

    /**
     * @param value The artifact store type.
     */
    @JvmName("qrcujqqrxufodapq")
    public suspend fun storeType(`value`: Either<String, ArtifactStoreType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storeType = mapped
    }

    /**
     * @param value The artifact store type.
     */
    @JvmName("ogeirhgwmwqyjcti")
    public fun storeType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ArtifactStoreType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storeType = mapped
    }

    /**
     * @param value The artifact store type.
     */
    @JvmName("kefwbmhujmsocxxh")
    public fun storeType(`value`: ArtifactStoreType) {
        val toBeMapped = Either.ofRight<String, ArtifactStoreType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storeType = mapped
    }

    internal fun build(): ArtifactStorePropertiesFormatArgs = ArtifactStorePropertiesFormatArgs(
        managedResourceGroupConfiguration = managedResourceGroupConfiguration,
        replicationStrategy = replicationStrategy,
        storeType = storeType,
    )
}
