@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property location The managed resource group location.
 * @property name The managed resource group name.
 */
public data class ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgs(
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgs].
 */
@PulumiTagMarker
public class ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The managed resource group location.
     */
    @JvmName("tpkhmidphgtudvfu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The managed resource group name.
     */
    @JvmName("khxfhdgyjedopecj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The managed resource group location.
     */
    @JvmName("qgwwjkblypwiownp")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The managed resource group name.
     */
    @JvmName("rgnfgvdtmlkrdwyh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgs =
        ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgs(
            location = location,
            name = name,
        )
}
