@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreNetworkFunctionArmTemplateApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure core network function Template application definition.
 * @property artifactProfile Azure template artifact profile.
 * @property artifactType The artifact type.
 * Expected value is 'ArmTemplate'.
 * @property dependsOnProfile Depends on profile definition.
 * @property deployParametersMappingRuleProfile Deploy mapping rule profile.
 * @property name The name of the network function application.
 */
public data class AzureCoreNetworkFunctionArmTemplateApplicationArgs(
    public val artifactProfile: Output<AzureCoreArmTemplateArtifactProfileArgs>? = null,
    public val artifactType: Output<String>,
    public val dependsOnProfile: Output<DependsOnProfileArgs>? = null,
    public val deployParametersMappingRuleProfile: Output<AzureCoreArmTemplateDeployMappingRuleProfileArgs>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreNetworkFunctionArmTemplateApplicationArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreNetworkFunctionArmTemplateApplicationArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreNetworkFunctionArmTemplateApplicationArgs.builder()
            .artifactProfile(artifactProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .artifactType(artifactType.applyValue({ args0 -> args0 }))
            .dependsOnProfile(dependsOnProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deployParametersMappingRuleProfile(
                deployParametersMappingRuleProfile?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureCoreNetworkFunctionArmTemplateApplicationArgs].
 */
@PulumiTagMarker
public class AzureCoreNetworkFunctionArmTemplateApplicationArgsBuilder internal constructor() {
    private var artifactProfile: Output<AzureCoreArmTemplateArtifactProfileArgs>? = null

    private var artifactType: Output<String>? = null

    private var dependsOnProfile: Output<DependsOnProfileArgs>? = null

    private var deployParametersMappingRuleProfile:
        Output<AzureCoreArmTemplateDeployMappingRuleProfileArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value Azure template artifact profile.
     */
    @JvmName("xdqoaxstoylslclv")
    public suspend fun artifactProfile(`value`: Output<AzureCoreArmTemplateArtifactProfileArgs>) {
        this.artifactProfile = value
    }

    /**
     * @param value The artifact type.
     * Expected value is 'ArmTemplate'.
     */
    @JvmName("lnktttqpgfimdqrp")
    public suspend fun artifactType(`value`: Output<String>) {
        this.artifactType = value
    }

    /**
     * @param value Depends on profile definition.
     */
    @JvmName("mhitoywipbirgqvn")
    public suspend fun dependsOnProfile(`value`: Output<DependsOnProfileArgs>) {
        this.dependsOnProfile = value
    }

    /**
     * @param value Deploy mapping rule profile.
     */
    @JvmName("eeawalltyglygopf")
    public suspend fun deployParametersMappingRuleProfile(`value`: Output<AzureCoreArmTemplateDeployMappingRuleProfileArgs>) {
        this.deployParametersMappingRuleProfile = value
    }

    /**
     * @param value The name of the network function application.
     */
    @JvmName("eejixdgvlwusxikb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Azure template artifact profile.
     */
    @JvmName("juwaakiggpogjycs")
    public suspend fun artifactProfile(`value`: AzureCoreArmTemplateArtifactProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactProfile = mapped
    }

    /**
     * @param argument Azure template artifact profile.
     */
    @JvmName("joqpetjbldtjuwxf")
    public suspend fun artifactProfile(argument: suspend AzureCoreArmTemplateArtifactProfileArgsBuilder.() -> Unit) {
        val toBeMapped = AzureCoreArmTemplateArtifactProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.artifactProfile = mapped
    }

    /**
     * @param value The artifact type.
     * Expected value is 'ArmTemplate'.
     */
    @JvmName("kcvpssehfnorqgfh")
    public suspend fun artifactType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.artifactType = mapped
    }

    /**
     * @param value Depends on profile definition.
     */
    @JvmName("qeaqtfidorhljicq")
    public suspend fun dependsOnProfile(`value`: DependsOnProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOnProfile = mapped
    }

    /**
     * @param argument Depends on profile definition.
     */
    @JvmName("ubsraghsaqgjrlnc")
    public suspend fun dependsOnProfile(argument: suspend DependsOnProfileArgsBuilder.() -> Unit) {
        val toBeMapped = DependsOnProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dependsOnProfile = mapped
    }

    /**
     * @param value Deploy mapping rule profile.
     */
    @JvmName("inghcrnvniqthfmq")
    public suspend fun deployParametersMappingRuleProfile(`value`: AzureCoreArmTemplateDeployMappingRuleProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deployParametersMappingRuleProfile = mapped
    }

    /**
     * @param argument Deploy mapping rule profile.
     */
    @JvmName("opowwvpktmteucoa")
    public suspend fun deployParametersMappingRuleProfile(argument: suspend AzureCoreArmTemplateDeployMappingRuleProfileArgsBuilder.() -> Unit) {
        val toBeMapped = AzureCoreArmTemplateDeployMappingRuleProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.deployParametersMappingRuleProfile = mapped
    }

    /**
     * @param value The name of the network function application.
     */
    @JvmName("brulvnlkeuqfahyj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): AzureCoreNetworkFunctionArmTemplateApplicationArgs =
        AzureCoreNetworkFunctionArmTemplateApplicationArgs(
            artifactProfile = artifactProfile,
            artifactType = artifactType ?: throw PulumiNullFieldException("artifactType"),
            dependsOnProfile = dependsOnProfile,
            deployParametersMappingRuleProfile = deployParametersMappingRuleProfile,
            name = name,
        )
}
