@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreVhdImageDeployMappingRuleProfileArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.enums.ApplicationEnablement
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure vhd deploy mapping rule profile.
 * @property applicationEnablement The application enablement.
 * @property vhdImageMappingRuleProfile The vhd mapping rule profile.
 */
public data class AzureCoreVhdImageDeployMappingRuleProfileArgs(
    public val applicationEnablement: Output<Either<String, ApplicationEnablement>>? = null,
    public val vhdImageMappingRuleProfile: Output<VhdImageMappingRuleProfileArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreVhdImageDeployMappingRuleProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreVhdImageDeployMappingRuleProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreVhdImageDeployMappingRuleProfileArgs.builder()
            .applicationEnablement(
                applicationEnablement?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .vhdImageMappingRuleProfile(
                vhdImageMappingRuleProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureCoreVhdImageDeployMappingRuleProfileArgs].
 */
@PulumiTagMarker
public class AzureCoreVhdImageDeployMappingRuleProfileArgsBuilder internal constructor() {
    private var applicationEnablement: Output<Either<String, ApplicationEnablement>>? = null

    private var vhdImageMappingRuleProfile: Output<VhdImageMappingRuleProfileArgs>? = null

    /**
     * @param value The application enablement.
     */
    @JvmName("yisesgmuqchihcdc")
    public suspend fun applicationEnablement(`value`: Output<Either<String, ApplicationEnablement>>) {
        this.applicationEnablement = value
    }

    /**
     * @param value The vhd mapping rule profile.
     */
    @JvmName("gywpgmmwhkisgchv")
    public suspend fun vhdImageMappingRuleProfile(`value`: Output<VhdImageMappingRuleProfileArgs>) {
        this.vhdImageMappingRuleProfile = value
    }

    /**
     * @param value The application enablement.
     */
    @JvmName("vkgtsaayowcnsygu")
    public suspend fun applicationEnablement(`value`: Either<String, ApplicationEnablement>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationEnablement = mapped
    }

    /**
     * @param value The application enablement.
     */
    @JvmName("ailcsnapfjahgmsv")
    public fun applicationEnablement(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationEnablement>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationEnablement = mapped
    }

    /**
     * @param value The application enablement.
     */
    @JvmName("ypjnhydftvcawefh")
    public fun applicationEnablement(`value`: ApplicationEnablement) {
        val toBeMapped = Either.ofRight<String, ApplicationEnablement>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationEnablement = mapped
    }

    /**
     * @param value The vhd mapping rule profile.
     */
    @JvmName("gdvrsgvfodosexir")
    public suspend fun vhdImageMappingRuleProfile(`value`: VhdImageMappingRuleProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vhdImageMappingRuleProfile = mapped
    }

    /**
     * @param argument The vhd mapping rule profile.
     */
    @JvmName("yxkgssosnnsjoroj")
    public suspend fun vhdImageMappingRuleProfile(argument: suspend VhdImageMappingRuleProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VhdImageMappingRuleProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vhdImageMappingRuleProfile = mapped
    }

    internal fun build(): AzureCoreVhdImageDeployMappingRuleProfileArgs =
        AzureCoreVhdImageDeployMappingRuleProfileArgs(
            applicationEnablement = applicationEnablement,
            vhdImageMappingRuleProfile = vhdImageMappingRuleProfile,
        )
}
