@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusImageArtifactProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Operator Distributed Services image artifact profile properties.
 * @property artifactStore The reference to artifact store.
 * @property imageArtifactProfile Image artifact profile.
 */
public data class AzureOperatorNexusImageArtifactProfileArgs(
    public val artifactStore: Output<ReferencedResourceArgs>? = null,
    public val imageArtifactProfile: Output<ImageArtifactProfileArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusImageArtifactProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusImageArtifactProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusImageArtifactProfileArgs.builder()
            .artifactStore(artifactStore?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .imageArtifactProfile(
                imageArtifactProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureOperatorNexusImageArtifactProfileArgs].
 */
@PulumiTagMarker
public class AzureOperatorNexusImageArtifactProfileArgsBuilder internal constructor() {
    private var artifactStore: Output<ReferencedResourceArgs>? = null

    private var imageArtifactProfile: Output<ImageArtifactProfileArgs>? = null

    /**
     * @param value The reference to artifact store.
     */
    @JvmName("ehwrxmsyhhjlqofl")
    public suspend fun artifactStore(`value`: Output<ReferencedResourceArgs>) {
        this.artifactStore = value
    }

    /**
     * @param value Image artifact profile.
     */
    @JvmName("psaxrnkvgnvctatp")
    public suspend fun imageArtifactProfile(`value`: Output<ImageArtifactProfileArgs>) {
        this.imageArtifactProfile = value
    }

    /**
     * @param value The reference to artifact store.
     */
    @JvmName("uktjtsvfrprqljie")
    public suspend fun artifactStore(`value`: ReferencedResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactStore = mapped
    }

    /**
     * @param argument The reference to artifact store.
     */
    @JvmName("bjknjwlwjrfvqhcg")
    public suspend fun artifactStore(argument: suspend ReferencedResourceArgsBuilder.() -> Unit) {
        val toBeMapped = ReferencedResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.artifactStore = mapped
    }

    /**
     * @param value Image artifact profile.
     */
    @JvmName("qodcmbxryhyuiexv")
    public suspend fun imageArtifactProfile(`value`: ImageArtifactProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageArtifactProfile = mapped
    }

    /**
     * @param argument Image artifact profile.
     */
    @JvmName("efgkbkcxvilbfbsq")
    public suspend fun imageArtifactProfile(argument: suspend ImageArtifactProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ImageArtifactProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.imageArtifactProfile = mapped
    }

    internal fun build(): AzureOperatorNexusImageArtifactProfileArgs =
        AzureOperatorNexusImageArtifactProfileArgs(
            artifactStore = artifactStore,
            imageArtifactProfile = imageArtifactProfile,
        )
}
