@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.GetConfigurationGroupSchemaPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationGroupSchemaName The name of the configuration group schema.
 * @property publisherName The name of the publisher.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetConfigurationGroupSchemaPlainArgs(
    public val configurationGroupSchemaName: String,
    public val publisherName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.GetConfigurationGroupSchemaPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.GetConfigurationGroupSchemaPlainArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.GetConfigurationGroupSchemaPlainArgs.builder()
            .configurationGroupSchemaName(configurationGroupSchemaName.let({ args0 -> args0 }))
            .publisherName(publisherName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigurationGroupSchemaPlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationGroupSchemaPlainArgsBuilder internal constructor() {
    private var configurationGroupSchemaName: String? = null

    private var publisherName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the configuration group schema.
     */
    @JvmName("bmbxibyonnmeaidj")
    public suspend fun configurationGroupSchemaName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationGroupSchemaName = mapped
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("kmxsktdqywohnfuw")
    public suspend fun publisherName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.publisherName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kebeetbxkcjgdlgf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConfigurationGroupSchemaPlainArgs = GetConfigurationGroupSchemaPlainArgs(
        configurationGroupSchemaName = configurationGroupSchemaName ?: throw
            PulumiNullFieldException("configurationGroupSchemaName"),
        publisherName = publisherName ?: throw PulumiNullFieldException("publisherName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
