@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.GetDevicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName The name of the device resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDevicePlainArgs(
    public val deviceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.GetDevicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.GetDevicePlainArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.GetDevicePlainArgs.builder()
            .deviceName(deviceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDevicePlainArgs].
 */
@PulumiTagMarker
public class GetDevicePlainArgsBuilder internal constructor() {
    private var deviceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the device resource.
     */
    @JvmName("tvscktqooscqusao")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ssorxngmswkveawd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDevicePlainArgs = GetDevicePlainArgs(
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
