@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.HelmMappingRuleProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Helm mapping rule profile
 * @property helmPackageVersion Helm package version.
 * @property options The helm deployment options
 * @property releaseName Helm release name.
 * @property releaseNamespace Helm release namespace.
 * @property values Helm release values.
 */
public data class HelmMappingRuleProfileArgs(
    public val helmPackageVersion: Output<String>? = null,
    public val options: Output<HelmMappingRuleProfileOptionsArgs>? = null,
    public val releaseName: Output<String>? = null,
    public val releaseNamespace: Output<String>? = null,
    public val values: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.HelmMappingRuleProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.HelmMappingRuleProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.HelmMappingRuleProfileArgs.builder()
            .helmPackageVersion(helmPackageVersion?.applyValue({ args0 -> args0 }))
            .options(options?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .releaseName(releaseName?.applyValue({ args0 -> args0 }))
            .releaseNamespace(releaseNamespace?.applyValue({ args0 -> args0 }))
            .values(values?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HelmMappingRuleProfileArgs].
 */
@PulumiTagMarker
public class HelmMappingRuleProfileArgsBuilder internal constructor() {
    private var helmPackageVersion: Output<String>? = null

    private var options: Output<HelmMappingRuleProfileOptionsArgs>? = null

    private var releaseName: Output<String>? = null

    private var releaseNamespace: Output<String>? = null

    private var values: Output<String>? = null

    /**
     * @param value Helm package version.
     */
    @JvmName("kntjqsjasprtnmbs")
    public suspend fun helmPackageVersion(`value`: Output<String>) {
        this.helmPackageVersion = value
    }

    /**
     * @param value The helm deployment options
     */
    @JvmName("mneiasatmmnfccvt")
    public suspend fun options(`value`: Output<HelmMappingRuleProfileOptionsArgs>) {
        this.options = value
    }

    /**
     * @param value Helm release name.
     */
    @JvmName("lqbfypmsuamuovik")
    public suspend fun releaseName(`value`: Output<String>) {
        this.releaseName = value
    }

    /**
     * @param value Helm release namespace.
     */
    @JvmName("gfykytevmqigpjig")
    public suspend fun releaseNamespace(`value`: Output<String>) {
        this.releaseNamespace = value
    }

    /**
     * @param value Helm release values.
     */
    @JvmName("faejqfebknoamgkf")
    public suspend fun values(`value`: Output<String>) {
        this.values = value
    }

    /**
     * @param value Helm package version.
     */
    @JvmName("ymgtkvnguftpuhbk")
    public suspend fun helmPackageVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.helmPackageVersion = mapped
    }

    /**
     * @param value The helm deployment options
     */
    @JvmName("erlbxwurnvxdbclu")
    public suspend fun options(`value`: HelmMappingRuleProfileOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument The helm deployment options
     */
    @JvmName("qvmnoudyhhwsuukj")
    public suspend fun options(argument: suspend HelmMappingRuleProfileOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = HelmMappingRuleProfileOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param value Helm release name.
     */
    @JvmName("ycfxlcarlykptboo")
    public suspend fun releaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseName = mapped
    }

    /**
     * @param value Helm release namespace.
     */
    @JvmName("tsnvmedhkbxgpppx")
    public suspend fun releaseNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseNamespace = mapped
    }

    /**
     * @param value Helm release values.
     */
    @JvmName("obtagbavlsqwhgsi")
    public suspend fun values(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): HelmMappingRuleProfileArgs = HelmMappingRuleProfileArgs(
        helmPackageVersion = helmPackageVersion,
        options = options,
        releaseName = releaseName,
        releaseNamespace = releaseNamespace,
        values = values,
    )
}
