@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.LinuxConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specifies the Linux operating system settings on the virtual machine.
 * @property ssh Specifies the ssh key configuration for a Linux OS.
 */
public data class LinuxConfigurationArgs(
    public val ssh: Output<SshConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.LinuxConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.LinuxConfigurationArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.LinuxConfigurationArgs.builder()
            .ssh(ssh?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LinuxConfigurationArgs].
 */
@PulumiTagMarker
public class LinuxConfigurationArgsBuilder internal constructor() {
    private var ssh: Output<SshConfigurationArgs>? = null

    /**
     * @param value Specifies the ssh key configuration for a Linux OS.
     */
    @JvmName("jftwqkmkrnamanwa")
    public suspend fun ssh(`value`: Output<SshConfigurationArgs>) {
        this.ssh = value
    }

    /**
     * @param value Specifies the ssh key configuration for a Linux OS.
     */
    @JvmName("stemrefajwcprwfu")
    public suspend fun ssh(`value`: SshConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssh = mapped
    }

    /**
     * @param argument Specifies the ssh key configuration for a Linux OS.
     */
    @JvmName("wroctxdafbytoqni")
    public suspend fun ssh(argument: suspend SshConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = SshConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ssh = mapped
    }

    internal fun build(): LinuxConfigurationArgs = LinuxConfigurationArgs(
        ssh = ssh,
    )
}
