@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionUserConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The network function user configuration.
 * @property networkInterfaces The network interface configuration.
 * @property osProfile Specifies the operating system settings for the role instance.
 * @property roleName The name of the network function role.
 * @property userDataParameters The user data parameters from the customer.
 */
public data class NetworkFunctionUserConfigurationArgs(
    public val networkInterfaces: Output<List<NetworkInterfaceArgs>>? = null,
    public val osProfile: Output<NetworkFunctionUserConfigurationOsProfileArgs>? = null,
    public val roleName: Output<String>? = null,
    public val userDataParameters: Output<Any>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionUserConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionUserConfigurationArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionUserConfigurationArgs.builder()
            .networkInterfaces(
                networkInterfaces?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .osProfile(osProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .roleName(roleName?.applyValue({ args0 -> args0 }))
            .userDataParameters(userDataParameters?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkFunctionUserConfigurationArgs].
 */
@PulumiTagMarker
public class NetworkFunctionUserConfigurationArgsBuilder internal constructor() {
    private var networkInterfaces: Output<List<NetworkInterfaceArgs>>? = null

    private var osProfile: Output<NetworkFunctionUserConfigurationOsProfileArgs>? = null

    private var roleName: Output<String>? = null

    private var userDataParameters: Output<Any>? = null

    /**
     * @param value The network interface configuration.
     */
    @JvmName("pgvaujycalylucit")
    public suspend fun networkInterfaces(`value`: Output<List<NetworkInterfaceArgs>>) {
        this.networkInterfaces = value
    }

    @JvmName("rhbwnnhdwfbptswk")
    public suspend fun networkInterfaces(vararg values: Output<NetworkInterfaceArgs>) {
        this.networkInterfaces = Output.all(values.asList())
    }

    /**
     * @param values The network interface configuration.
     */
    @JvmName("hxpsftvhojacpqqt")
    public suspend fun networkInterfaces(values: List<Output<NetworkInterfaceArgs>>) {
        this.networkInterfaces = Output.all(values)
    }

    /**
     * @param value Specifies the operating system settings for the role instance.
     */
    @JvmName("asrrjhwhvdqgkmth")
    public suspend fun osProfile(`value`: Output<NetworkFunctionUserConfigurationOsProfileArgs>) {
        this.osProfile = value
    }

    /**
     * @param value The name of the network function role.
     */
    @JvmName("jrtqgavenncaghip")
    public suspend fun roleName(`value`: Output<String>) {
        this.roleName = value
    }

    /**
     * @param value The user data parameters from the customer.
     */
    @JvmName("dnffukdgfoxxeeib")
    public suspend fun userDataParameters(`value`: Output<Any>) {
        this.userDataParameters = value
    }

    /**
     * @param value The network interface configuration.
     */
    @JvmName("unuqkobdsrteicjx")
    public suspend fun networkInterfaces(`value`: List<NetworkInterfaceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param argument The network interface configuration.
     */
    @JvmName("horanlsytotclfyh")
    public suspend fun networkInterfaces(argument: List<suspend NetworkInterfaceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkInterfaceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument The network interface configuration.
     */
    @JvmName("iiagxkkamngrnsfn")
    public suspend fun networkInterfaces(vararg argument: suspend NetworkInterfaceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NetworkInterfaceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument The network interface configuration.
     */
    @JvmName("odpkmfkhfylbqnjo")
    public suspend fun networkInterfaces(argument: suspend NetworkInterfaceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NetworkInterfaceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param values The network interface configuration.
     */
    @JvmName("tbpwqgwxhhyfnlvr")
    public suspend fun networkInterfaces(vararg values: NetworkInterfaceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param value Specifies the operating system settings for the role instance.
     */
    @JvmName("qlcftaywksrfqfbf")
    public suspend fun osProfile(`value`: NetworkFunctionUserConfigurationOsProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osProfile = mapped
    }

    /**
     * @param argument Specifies the operating system settings for the role instance.
     */
    @JvmName("dqudallhnthybdht")
    public suspend fun osProfile(argument: suspend NetworkFunctionUserConfigurationOsProfileArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkFunctionUserConfigurationOsProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.osProfile = mapped
    }

    /**
     * @param value The name of the network function role.
     */
    @JvmName("cdxghkhofffgxkxn")
    public suspend fun roleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleName = mapped
    }

    /**
     * @param value The user data parameters from the customer.
     */
    @JvmName("xqaqwxaxqafxeaae")
    public suspend fun userDataParameters(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDataParameters = mapped
    }

    internal fun build(): NetworkFunctionUserConfigurationArgs = NetworkFunctionUserConfigurationArgs(
        networkInterfaces = networkInterfaces,
        osProfile = osProfile,
        roleName = roleName,
        userDataParameters = userDataParameters,
    )
}
