@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionUserConfigurationOsProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the operating system settings for the role instance.
 * @property customData Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the virtual machine. The maximum length of the binary array is 65535 bytes. <br><br> **Note: Do not pass any secrets or passwords in customData property** <br><br> This property cannot be updated after the VM is created. <br><br> customData is passed to the VM to be saved as a file. For more information see [Custom Data on Azure VMs](https://azure&#46;microsoft&#46;com/en-us/blog/custom-data-and-cloud-init-on-windows-azure/) <br><br> For using cloud-init for your Linux VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
 */
public data class NetworkFunctionUserConfigurationOsProfileArgs(
    public val customData: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionUserConfigurationOsProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionUserConfigurationOsProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionUserConfigurationOsProfileArgs.builder()
            .customData(customData?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkFunctionUserConfigurationOsProfileArgs].
 */
@PulumiTagMarker
public class NetworkFunctionUserConfigurationOsProfileArgsBuilder internal constructor() {
    private var customData: Output<String>? = null

    /**
     * @param value Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the virtual machine. The maximum length of the binary array is 65535 bytes. <br><br> **Note: Do not pass any secrets or passwords in customData property** <br><br> This property cannot be updated after the VM is created. <br><br> customData is passed to the VM to be saved as a file. For more information see [Custom Data on Azure VMs](https://azure&#46;microsoft&#46;com/en-us/blog/custom-data-and-cloud-init-on-windows-azure/) <br><br> For using cloud-init for your Linux VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
     */
    @JvmName("hwkwtqmbwmrdnabn")
    public suspend fun customData(`value`: Output<String>) {
        this.customData = value
    }

    /**
     * @param value Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the virtual machine. The maximum length of the binary array is 65535 bytes. <br><br> **Note: Do not pass any secrets or passwords in customData property** <br><br> This property cannot be updated after the VM is created. <br><br> customData is passed to the VM to be saved as a file. For more information see [Custom Data on Azure VMs](https://azure&#46;microsoft&#46;com/en-us/blog/custom-data-and-cloud-init-on-windows-azure/) <br><br> For using cloud-init for your Linux VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
     */
    @JvmName("nsymogpvgukfaxjm")
    public suspend fun customData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customData = mapped
    }

    internal fun build(): NetworkFunctionUserConfigurationOsProfileArgs =
        NetworkFunctionUserConfigurationOsProfileArgs(
            customData = customData,
        )
}
