@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.NfviDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The nfvi details.
 * @property name The nfvi name.
 * @property type The nfvi type.
 */
public data class NfviDetailsArgs(
    public val name: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.NfviDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.NfviDetailsArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.NfviDetailsArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NfviDetailsArgs].
 */
@PulumiTagMarker
public class NfviDetailsArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The nfvi name.
     */
    @JvmName("rybwwsphbenertxk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The nfvi type.
     */
    @JvmName("obembnolahhkdfmv")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The nfvi name.
     */
    @JvmName("wqljsfiglpmilhyd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The nfvi type.
     */
    @JvmName("iospempittfcidxe")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): NfviDetailsArgs = NfviDetailsArgs(
        name = name,
        type = type,
    )
}
