@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.PublisherPropertiesFormatArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.enums.PublisherScope
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * publisher properties.
 * @property scope The publisher scope.
 */
public data class PublisherPropertiesFormatArgs(
    public val scope: Output<Either<String, PublisherScope>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.PublisherPropertiesFormatArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.PublisherPropertiesFormatArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.PublisherPropertiesFormatArgs.builder()
            .scope(
                scope?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PublisherPropertiesFormatArgs].
 */
@PulumiTagMarker
public class PublisherPropertiesFormatArgsBuilder internal constructor() {
    private var scope: Output<Either<String, PublisherScope>>? = null

    /**
     * @param value The publisher scope.
     */
    @JvmName("vkmosjrmmbdnqltd")
    public suspend fun scope(`value`: Output<Either<String, PublisherScope>>) {
        this.scope = value
    }

    /**
     * @param value The publisher scope.
     */
    @JvmName("jntklqrojyafdbep")
    public suspend fun scope(`value`: Either<String, PublisherScope>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The publisher scope.
     */
    @JvmName("higordysxylwmwlq")
    public fun scope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublisherScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The publisher scope.
     */
    @JvmName("eifehjwejuwtgvpq")
    public fun scope(`value`: PublisherScope) {
        val toBeMapped = Either.ofRight<String, PublisherScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): PublisherPropertiesFormatArgs = PublisherPropertiesFormatArgs(
        scope = scope,
    )
}
