@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.SecretDeploymentResourceReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Secret deployment resource id reference.
 * @property id Resource ID.
 * @property idType The resource reference arm id type.
 * Expected value is 'Secret'.
 */
public data class SecretDeploymentResourceReferenceArgs(
    public val id: Output<String>? = null,
    public val idType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.SecretDeploymentResourceReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.SecretDeploymentResourceReferenceArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.SecretDeploymentResourceReferenceArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .idType(idType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretDeploymentResourceReferenceArgs].
 */
@PulumiTagMarker
public class SecretDeploymentResourceReferenceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var idType: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("xxbpilasmsyhktyn")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The resource reference arm id type.
     * Expected value is 'Secret'.
     */
    @JvmName("wymypwdrhukcqamv")
    public suspend fun idType(`value`: Output<String>) {
        this.idType = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("pwsjvoeixmmiypri")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The resource reference arm id type.
     * Expected value is 'Secret'.
     */
    @JvmName("fotnwpggbddxstgd")
    public suspend fun idType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.idType = mapped
    }

    internal fun build(): SecretDeploymentResourceReferenceArgs =
        SecretDeploymentResourceReferenceArgs(
            id = id,
            idType = idType ?: throw PulumiNullFieldException("idType"),
        )
}
