@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.SitePropertiesFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Site properties.
 * @property nfvis List of NFVIs
 */
public data class SitePropertiesFormatArgs(
    public val nfvis: Output<List<Any>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.SitePropertiesFormatArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.SitePropertiesFormatArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.SitePropertiesFormatArgs.builder()
            .nfvis(nfvis?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SitePropertiesFormatArgs].
 */
@PulumiTagMarker
public class SitePropertiesFormatArgsBuilder internal constructor() {
    private var nfvis: Output<List<Any>>? = null

    /**
     * @param value List of NFVIs
     */
    @JvmName("sfatpcfvxjjixsfu")
    public suspend fun nfvis(`value`: Output<List<Any>>) {
        this.nfvis = value
    }

    @JvmName("pnxivpnnknkrknsh")
    public suspend fun nfvis(vararg values: Output<Any>) {
        this.nfvis = Output.all(values.asList())
    }

    /**
     * @param values List of NFVIs
     */
    @JvmName("oancuxkektqrbloy")
    public suspend fun nfvis(values: List<Output<Any>>) {
        this.nfvis = Output.all(values)
    }

    /**
     * @param value List of NFVIs
     */
    @JvmName("arrcnntveawkwmox")
    public suspend fun nfvis(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfvis = mapped
    }

    /**
     * @param values List of NFVIs
     */
    @JvmName("aiyaohkmorsgxsix")
    public suspend fun nfvis(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nfvis = mapped
    }

    internal fun build(): SitePropertiesFormatArgs = SitePropertiesFormatArgs(
        nfvis = nfvis,
    )
}
