@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.VhdImageArtifactProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Vhd artifact profile.
 * @property vhdName Vhd name.
 * @property vhdVersion Vhd version.
 */
public data class VhdImageArtifactProfileArgs(
    public val vhdName: Output<String>? = null,
    public val vhdVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.VhdImageArtifactProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.VhdImageArtifactProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.VhdImageArtifactProfileArgs.builder()
            .vhdName(vhdName?.applyValue({ args0 -> args0 }))
            .vhdVersion(vhdVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VhdImageArtifactProfileArgs].
 */
@PulumiTagMarker
public class VhdImageArtifactProfileArgsBuilder internal constructor() {
    private var vhdName: Output<String>? = null

    private var vhdVersion: Output<String>? = null

    /**
     * @param value Vhd name.
     */
    @JvmName("ooyryvnpbtdedpcl")
    public suspend fun vhdName(`value`: Output<String>) {
        this.vhdName = value
    }

    /**
     * @param value Vhd version.
     */
    @JvmName("dnjldivrupsinrob")
    public suspend fun vhdVersion(`value`: Output<String>) {
        this.vhdVersion = value
    }

    /**
     * @param value Vhd name.
     */
    @JvmName("rrljelxgmuhqqpwc")
    public suspend fun vhdName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vhdName = mapped
    }

    /**
     * @param value Vhd version.
     */
    @JvmName("jqrngytrgfmcvvdr")
    public suspend fun vhdVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vhdVersion = mapped
    }

    internal fun build(): VhdImageArtifactProfileArgs = VhdImageArtifactProfileArgs(
        vhdName = vhdName,
        vhdVersion = vhdVersion,
    )
}
