@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The arm resource definition resource element template details.
 * @property configuration The resource element template type.
 * @property dependsOnProfile The depends on profile.
 * @property name Name of the resource element template.
 * @property resourceElementType The resource element template type.
 * Expected value is 'ArmResourceDefinition'.
 */
public data class ArmResourceDefinitionResourceElementTemplateDetailsResponse(
    public val configuration: ArmResourceDefinitionResourceElementTemplateResponse? = null,
    public val dependsOnProfile: DependsOnProfileResponse? = null,
    public val name: String? = null,
    public val resourceElementType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.ArmResourceDefinitionResourceElementTemplateDetailsResponse): ArmResourceDefinitionResourceElementTemplateDetailsResponse =
            ArmResourceDefinitionResourceElementTemplateDetailsResponse(
                configuration = javaType.configuration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ArmResourceDefinitionResourceElementTemplateResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                dependsOnProfile = javaType.dependsOnProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.DependsOnProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                resourceElementType = javaType.resourceElementType(),
            )
    }
}
