@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The arm template RE.
 * @property artifactProfile Artifact profile properties.
 * @property parameterValues Name and value pairs that define the parameter values. It can be  a well formed escaped JSON string.
 * @property templateType The template type.
 */
public data class ArmResourceDefinitionResourceElementTemplateResponse(
    public val artifactProfile: NSDArtifactProfileResponse? = null,
    public val parameterValues: String? = null,
    public val templateType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.ArmResourceDefinitionResourceElementTemplateResponse): ArmResourceDefinitionResourceElementTemplateResponse =
            ArmResourceDefinitionResourceElementTemplateResponse(
                artifactProfile = javaType.artifactProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.NSDArtifactProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                parameterValues = javaType.parameterValues().map({ args0 -> args0 }).orElse(null),
                templateType = javaType.templateType().map({ args0 -> args0 }).orElse(null),
            )
    }
}
