@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Template artifact profile.
 * @property templateName Template name.
 * @property templateVersion Template version.
 */
public data class ArmTemplateArtifactProfileResponse(
    public val templateName: String? = null,
    public val templateVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.ArmTemplateArtifactProfileResponse): ArmTemplateArtifactProfileResponse = ArmTemplateArtifactProfileResponse(
            templateName = javaType.templateName().map({ args0 -> args0 }).orElse(null),
            templateVersion = javaType.templateVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
