@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure arc kubernetes deploy mapping rule profile.
 * @property applicationEnablement The application enablement.
 * @property helmMappingRuleProfile The helm mapping rule profile.
 */
public data class AzureArcKubernetesDeployMappingRuleProfileResponse(
    public val applicationEnablement: String? = null,
    public val helmMappingRuleProfile: HelmMappingRuleProfileResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.AzureArcKubernetesDeployMappingRuleProfileResponse): AzureArcKubernetesDeployMappingRuleProfileResponse =
            AzureArcKubernetesDeployMappingRuleProfileResponse(
                applicationEnablement = javaType.applicationEnablement().map({ args0 -> args0 }).orElse(null),
                helmMappingRuleProfile = javaType.helmMappingRuleProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.HelmMappingRuleProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
