@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.Suppress

/**
 * Azure template artifact profile properties.
 * @property artifactStore The reference to artifact store.
 * @property templateArtifactProfile Template artifact profile.
 */
public data class AzureCoreArmTemplateArtifactProfileResponse(
    public val artifactStore: ReferencedResourceResponse? = null,
    public val templateArtifactProfile: ArmTemplateArtifactProfileResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.AzureCoreArmTemplateArtifactProfileResponse): AzureCoreArmTemplateArtifactProfileResponse = AzureCoreArmTemplateArtifactProfileResponse(
            artifactStore = javaType.artifactStore().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ReferencedResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            templateArtifactProfile = javaType.templateArtifactProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ArmTemplateArtifactProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
