@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure core network function vhd application definition.
 * @property artifactProfile Azure vhd image artifact profile.
 * @property artifactType The artifact type.
 * Expected value is 'VhdImageFile'.
 * @property dependsOnProfile Depends on profile definition.
 * @property deployParametersMappingRuleProfile Deploy mapping rule profile.
 * @property name The name of the network function application.
 */
public data class AzureCoreNetworkFunctionVhdApplicationResponse(
    public val artifactProfile: AzureCoreVhdImageArtifactProfileResponse? = null,
    public val artifactType: String,
    public val dependsOnProfile: DependsOnProfileResponse? = null,
    public val deployParametersMappingRuleProfile: AzureCoreVhdImageDeployMappingRuleProfileResponse? =
        null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.AzureCoreNetworkFunctionVhdApplicationResponse): AzureCoreNetworkFunctionVhdApplicationResponse =
            AzureCoreNetworkFunctionVhdApplicationResponse(
                artifactProfile = javaType.artifactProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.AzureCoreVhdImageArtifactProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                artifactType = javaType.artifactType(),
                dependsOnProfile = javaType.dependsOnProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.DependsOnProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                deployParametersMappingRuleProfile = javaType.deployParametersMappingRuleProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.AzureCoreVhdImageDeployMappingRuleProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
            )
    }
}
