@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure Operator Distributed Services network function Template application definition.
 * @property artifactProfile Azure Operator Distributed Services Template artifact profile.
 * @property artifactType The artifact type.
 * Expected value is 'ArmTemplate'.
 * @property dependsOnProfile Depends on profile definition.
 * @property deployParametersMappingRuleProfile Deploy mapping rule profile.
 * @property name The name of the network function application.
 */
public data class AzureOperatorNexusNetworkFunctionArmTemplateApplicationResponse(
    public val artifactProfile: AzureOperatorNexusArmTemplateArtifactProfileResponse? = null,
    public val artifactType: String,
    public val dependsOnProfile: DependsOnProfileResponse? = null,
    public val deployParametersMappingRuleProfile: AzureOperatorNexusArmTemplateDeployMappingRuleProfileResponse? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.AzureOperatorNexusNetworkFunctionArmTemplateApplicationResponse): AzureOperatorNexusNetworkFunctionArmTemplateApplicationResponse =
            AzureOperatorNexusNetworkFunctionArmTemplateApplicationResponse(
                artifactProfile = javaType.artifactProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.AzureOperatorNexusArmTemplateArtifactProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                artifactType = javaType.artifactType(),
                dependsOnProfile = javaType.dependsOnProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.DependsOnProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                deployParametersMappingRuleProfile = javaType.deployParametersMappingRuleProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.AzureOperatorNexusArmTemplateDeployMappingRuleProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
            )
    }
}
