@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure Operator Distributed Services network function image application definition.
 * @property artifactProfile Azure Operator Distributed Services image artifact profile.
 * @property artifactType The artifact type.
 * Expected value is 'ImageFile'.
 * @property dependsOnProfile Depends on profile definition.
 * @property deployParametersMappingRuleProfile Deploy mapping rule profile.
 * @property name The name of the network function application.
 */
public data class AzureOperatorNexusNetworkFunctionImageApplicationResponse(
    public val artifactProfile: AzureOperatorNexusImageArtifactProfileResponse? = null,
    public val artifactType: String,
    public val dependsOnProfile: DependsOnProfileResponse? = null,
    public val deployParametersMappingRuleProfile: AzureOperatorNexusImageDeployMappingRuleProfileResponse? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.AzureOperatorNexusNetworkFunctionImageApplicationResponse): AzureOperatorNexusNetworkFunctionImageApplicationResponse =
            AzureOperatorNexusNetworkFunctionImageApplicationResponse(
                artifactProfile = javaType.artifactProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.AzureOperatorNexusImageArtifactProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                artifactType = javaType.artifactType(),
                dependsOnProfile = javaType.dependsOnProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.DependsOnProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                deployParametersMappingRuleProfile = javaType.deployParametersMappingRuleProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.AzureOperatorNexusImageDeployMappingRuleProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
            )
    }
}
