@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
 * @property createOption Specifies how the virtual machine should be created.
 * @property diskSizeGB Specifies the size of an empty disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image.
 * @property name The name of data disk.
 */
public data class DataDiskResponse(
    public val createOption: String? = null,
    public val diskSizeGB: Int? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.DataDiskResponse): DataDiskResponse = DataDiskResponse(
            createOption = javaType.createOption().map({ args0 -> args0 }).orElse(null),
            diskSizeGB = javaType.diskSizeGB().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
