@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Sku sub resource.
 * @property deploymentMode The sku deployment mode.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property managedApplicationParameters The parameters for the managed application to be supplied by the vendor.
 * @property managedApplicationTemplate The template for the managed application deployment.
 * @property name The name of the resource
 * @property networkFunctionTemplate The template definition of the network function.
 * @property networkFunctionType The network function type.
 * @property preview Indicates if the vendor sku is in preview mode.
 * @property provisioningState The provisioning state of the vendor sku sub resource.
 * @property skuType The sku type.
 * @property systemData The system meta data relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetVendorSkusResult(
    public val deploymentMode: String? = null,
    public val id: String,
    public val managedApplicationParameters: Any? = null,
    public val managedApplicationTemplate: Any? = null,
    public val name: String,
    public val networkFunctionTemplate: NetworkFunctionTemplateResponse? = null,
    public val networkFunctionType: String? = null,
    public val preview: Boolean? = null,
    public val provisioningState: String,
    public val skuType: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.GetVendorSkusResult): GetVendorSkusResult = GetVendorSkusResult(
            deploymentMode = javaType.deploymentMode().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            managedApplicationParameters = javaType.managedApplicationParameters().map({ args0 ->
                args0
            }).orElse(null),
            managedApplicationTemplate = javaType.managedApplicationTemplate().map({ args0 ->
                args0
            }).orElse(null),
            name = javaType.name(),
            networkFunctionTemplate = javaType.networkFunctionTemplate().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.NetworkFunctionTemplateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            networkFunctionType = javaType.networkFunctionType().map({ args0 -> args0 }).orElse(null),
            preview = javaType.preview().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            skuType = javaType.skuType().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
