@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Helm artifact profile.
 * @property helmPackageName Helm package name.
 * @property helmPackageVersionRange Helm package version range.
 * @property imagePullSecretsValuesPaths The image pull secrets values path list.
 * @property registryValuesPaths The registry values path list.
 */
public data class HelmArtifactProfileResponse(
    public val helmPackageName: String? = null,
    public val helmPackageVersionRange: String? = null,
    public val imagePullSecretsValuesPaths: List<String>? = null,
    public val registryValuesPaths: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.HelmArtifactProfileResponse): HelmArtifactProfileResponse = HelmArtifactProfileResponse(
            helmPackageName = javaType.helmPackageName().map({ args0 -> args0 }).orElse(null),
            helmPackageVersionRange = javaType.helmPackageVersionRange().map({ args0 -> args0 }).orElse(null),
            imagePullSecretsValuesPaths = javaType.imagePullSecretsValuesPaths().map({ args0 -> args0 }),
            registryValuesPaths = javaType.registryValuesPaths().map({ args0 -> args0 }),
        )
    }
}
