@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.Suppress

/**
 * The helm deployment options
 * @property installOptions The helm deployment install options
 * @property upgradeOptions The helm deployment upgrade options
 */
public data class HelmMappingRuleProfileResponseOptions(
    public val installOptions: HelmInstallOptionsResponse? = null,
    public val upgradeOptions: HelmUpgradeOptionsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.HelmMappingRuleProfileResponseOptions): HelmMappingRuleProfileResponseOptions = HelmMappingRuleProfileResponseOptions(
            installOptions = javaType.installOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.HelmInstallOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            upgradeOptions = javaType.upgradeOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.HelmUpgradeOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
