@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The helm deployment install options
 * @property atomic The helm deployment atomic options
 * @property timeout The helm deployment timeout options
 * @property wait The helm deployment wait options
 */
public data class HelmUpgradeOptionsResponse(
    public val atomic: String? = null,
    public val timeout: String? = null,
    public val wait: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.HelmUpgradeOptionsResponse): HelmUpgradeOptionsResponse = HelmUpgradeOptionsResponse(
            atomic = javaType.atomic().map({ args0 -> args0 }).orElse(null),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
            wait = javaType.wait_().map({ args0 -> args0 }).orElse(null),
        )
    }
}
