@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The image reference properties.
 * @property exactVersion Specifies in decimal numbers, the exact version of image used to create the virtual machine.
 * @property offer Specifies the offer of the image used to create the virtual machine.
 * @property publisher The image publisher.
 * @property sku The image SKU.
 * @property version Specifies the version of the image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
 */
public data class ImageReferenceResponse(
    public val exactVersion: String? = null,
    public val offer: String? = null,
    public val publisher: String? = null,
    public val sku: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.ImageReferenceResponse): ImageReferenceResponse = ImageReferenceResponse(
            exactVersion = javaType.exactVersion().map({ args0 -> args0 }).orElse(null),
            offer = javaType.offer().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
