@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Managed resource group configuration.
 * @property location Managed resource group location.
 * @property name Managed resource group name.
 */
public data class ManagedResourceGroupConfigurationResponse(
    public val location: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.ManagedResourceGroupConfigurationResponse): ManagedResourceGroupConfigurationResponse = ManagedResourceGroupConfigurationResponse(
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
