@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Artifact profile properties.
 * @property artifactName Artifact name.
 * @property artifactStoreReference The artifact store resource id
 * @property artifactVersion Artifact version.
 */
public data class NSDArtifactProfileResponse(
    public val artifactName: String? = null,
    public val artifactStoreReference: ReferencedResourceResponse? = null,
    public val artifactVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.NSDArtifactProfileResponse): NSDArtifactProfileResponse = NSDArtifactProfileResponse(
            artifactName = javaType.artifactName().map({ args0 -> args0 }).orElse(null),
            artifactStoreReference = javaType.artifactStoreReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ReferencedResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            artifactVersion = javaType.artifactVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
