@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Network function definition group properties.
 * @property description The network function definition group description.
 * @property provisioningState The provisioning state of the network function definition groups resource.
 */
public data class NetworkFunctionDefinitionGroupPropertiesFormatResponse(
    public val description: String? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.NetworkFunctionDefinitionGroupPropertiesFormatResponse): NetworkFunctionDefinitionGroupPropertiesFormatResponse =
            NetworkFunctionDefinitionGroupPropertiesFormatResponse(
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                provisioningState = javaType.provisioningState(),
            )
    }
}
