@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Network function role configuration.
 * @property customProfile Specifies the custom settings for the virtual machine.
 * @property networkInterfaces The network interface configurations.
 * @property osProfile Specifies the operating system settings for the role instance. This value can be updated during the deployment of network function.
 * @property roleName The name of the network function role.
 * @property roleType Role type.
 * @property storageProfile Specifies the storage settings for the virtual machine disks.
 * @property userDataParameters The user parameters for customers. The format of user data parameters has to be matched with the provided user data template.
 * @property userDataTemplate The user data template for customers. This is a json schema template describing the format and data type of user data parameters.
 * @property virtualMachineSize The size of the virtual machine.
 */
public data class NetworkFunctionRoleConfigurationResponse(
    public val customProfile: CustomProfileResponse? = null,
    public val networkInterfaces: List<NetworkInterfaceResponse>? = null,
    public val osProfile: OsProfileResponse? = null,
    public val roleName: String? = null,
    public val roleType: String? = null,
    public val storageProfile: StorageProfileResponse? = null,
    public val userDataParameters: Any? = null,
    public val userDataTemplate: Any? = null,
    public val virtualMachineSize: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.NetworkFunctionRoleConfigurationResponse): NetworkFunctionRoleConfigurationResponse = NetworkFunctionRoleConfigurationResponse(
            customProfile = javaType.customProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.CustomProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            networkInterfaces = javaType.networkInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.NetworkInterfaceResponse.Companion.toKotlin(args0)
                })
            }),
            osProfile = javaType.osProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.OsProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            roleName = javaType.roleName().map({ args0 -> args0 }).orElse(null),
            roleType = javaType.roleType().map({ args0 -> args0 }).orElse(null),
            storageProfile = javaType.storageProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.StorageProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            userDataParameters = javaType.userDataParameters().map({ args0 -> args0 }).orElse(null),
            userDataTemplate = javaType.userDataTemplate().map({ args0 -> args0 }).orElse(null),
            virtualMachineSize = javaType.virtualMachineSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
