@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Network interface IP configuration properties.
 * @property dnsServers The list of DNS servers IP addresses.
 * @property gateway The value of the gateway.
 * @property ipAddress The value of the IP address.
 * @property ipAllocationMethod IP address allocation method.
 * @property ipVersion IP address version.
 * @property subnet The value of the subnet.
 */
public data class NetworkInterfaceIPConfigurationResponse(
    public val dnsServers: List<String>? = null,
    public val gateway: String? = null,
    public val ipAddress: String? = null,
    public val ipAllocationMethod: String? = null,
    public val ipVersion: String? = null,
    public val subnet: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.NetworkInterfaceIPConfigurationResponse): NetworkInterfaceIPConfigurationResponse = NetworkInterfaceIPConfigurationResponse(
            dnsServers = javaType.dnsServers().map({ args0 -> args0 }),
            gateway = javaType.gateway().map({ args0 -> args0 }).orElse(null),
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            ipAllocationMethod = javaType.ipAllocationMethod().map({ args0 -> args0 }).orElse(null),
            ipVersion = javaType.ipVersion().map({ args0 -> args0 }).orElse(null),
            subnet = javaType.subnet().map({ args0 -> args0 }).orElse(null),
        )
    }
}
