@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Network interface properties.
 * @property ipConfigurations A list of IP configurations of the network interface.
 * @property macAddress The MAC address of the network interface.
 * @property networkInterfaceName The name of the network interface.
 * @property vmSwitchType The type of the VM switch.
 */
public data class NetworkInterfaceResponse(
    public val ipConfigurations: List<NetworkInterfaceIPConfigurationResponse>? = null,
    public val macAddress: String? = null,
    public val networkInterfaceName: String? = null,
    public val vmSwitchType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.NetworkInterfaceResponse): NetworkInterfaceResponse = NetworkInterfaceResponse(
            ipConfigurations = javaType.ipConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.NetworkInterfaceIPConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            macAddress = javaType.macAddress().map({ args0 -> args0 }).orElse(null),
            networkInterfaceName = javaType.networkInterfaceName().map({ args0 -> args0 }).orElse(null),
            vmSwitchType = javaType.vmSwitchType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
