@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * network service design group properties.
 * @property description The network service design group description.
 * @property provisioningState The provisioning state of the network service design groups resource.
 */
public data class NetworkServiceDesignGroupPropertiesFormatResponse(
    public val description: String? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.NetworkServiceDesignGroupPropertiesFormatResponse): NetworkServiceDesignGroupPropertiesFormatResponse =
            NetworkServiceDesignGroupPropertiesFormatResponse(
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                provisioningState = javaType.provisioningState(),
            )
    }
}
