@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * network service design version properties.
 * @property configurationGroupSchemaReferences The configuration schemas to used to define the values.
 * @property description The network service design version description.
 * @property nfvisFromSite The nfvis from the site.
 * @property provisioningState The provisioning state of the network service design version resource.
 * @property resourceElementTemplates List of resource element template
 * @property versionState The network service design version state.
 */
public data class NetworkServiceDesignVersionPropertiesFormatResponse(
    public val configurationGroupSchemaReferences: Map<String, ReferencedResourceResponse>? = null,
    public val description: String? = null,
    public val nfvisFromSite: Map<String, NfviDetailsResponse>? = null,
    public val provisioningState: String,
    public val resourceElementTemplates: List<Either<ArmResourceDefinitionResourceElementTemplateDetailsResponse, NetworkFunctionDefinitionResourceElementTemplateDetailsResponse>>? =
        null,
    public val versionState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.NetworkServiceDesignVersionPropertiesFormatResponse): NetworkServiceDesignVersionPropertiesFormatResponse =
            NetworkServiceDesignVersionPropertiesFormatResponse(
                configurationGroupSchemaReferences = javaType.configurationGroupSchemaReferences().map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ReferencedResourceResponse.Companion.toKotlin(args0)
                        }),
                    )
                }).toMap(),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                nfvisFromSite = javaType.nfvisFromSite().map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            com.pulumi.azurenative.hybridnetwork.kotlin.outputs.NfviDetailsResponse.Companion.toKotlin(args0)
                        }),
                    )
                }).toMap(),
                provisioningState = javaType.provisioningState(),
                resourceElementTemplates = javaType.resourceElementTemplates().map({ args0 ->
                    args0.transform(
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ArmResourceDefinitionResourceElementTemplateDetailsResponse.Companion.toKotlin(args0)
                            })
                        },
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.hybridnetwork.kotlin.outputs.NetworkFunctionDefinitionResourceElementTemplateDetailsResponse.Companion.toKotlin(args0)
                            })
                        },
                    )
                }),
                versionState = javaType.versionState(),
            )
    }
}
