@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Non secret deployment resource id reference.
 * @property id Resource ID.
 * @property idType The resource reference arm id type.
 * Expected value is 'Open'.
 */
public data class OpenDeploymentResourceReferenceResponse(
    public val id: String? = null,
    public val idType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.OpenDeploymentResourceReferenceResponse): OpenDeploymentResourceReferenceResponse = OpenDeploymentResourceReferenceResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            idType = javaType.idType(),
        )
    }
}
