@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Sku, to be associated with a SiteNetworkService.
 * @property name Name of this Sku
 * @property tier The SKU tier based on the SKU name.
 */
public data class SkuResponse(
    public val name: String,
    public val tier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.SkuResponse): SkuResponse = SkuResponse(
            name = javaType.name(),
            tier = javaType.tier(),
        )
    }
}
