@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Vhd artifact profile.
 * @property vhdName Vhd name.
 * @property vhdVersion Vhd version.
 */
public data class VhdImageArtifactProfileResponse(
    public val vhdName: String? = null,
    public val vhdVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.VhdImageArtifactProfileResponse): VhdImageArtifactProfileResponse = VhdImageArtifactProfileResponse(
            vhdName = javaType.vhdName().map({ args0 -> args0 }).orElse(null),
            vhdVersion = javaType.vhdVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
