@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * Virtual network function network function definition version properties.
 * @property deployParameters The deployment parameters of the network function definition version.
 * @property description The network function definition version description.
 * @property networkFunctionTemplate Virtual network function template.
 * @property networkFunctionType The network function type.
 * Expected value is 'VirtualNetworkFunction'.
 * @property provisioningState The provisioning state of the network function definition version resource.
 * @property versionState The network function definition version state.
 */
public data class VirtualNetworkFunctionNetworkFunctionDefinitionVersionResponse(
    public val deployParameters: String? = null,
    public val description: String? = null,
    public val networkFunctionTemplate: Either<AzureCoreNetworkFunctionTemplateResponse, AzureOperatorNexusNetworkFunctionTemplateResponse>? =
        null,
    public val networkFunctionType: String,
    public val provisioningState: String,
    public val versionState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.VirtualNetworkFunctionNetworkFunctionDefinitionVersionResponse): VirtualNetworkFunctionNetworkFunctionDefinitionVersionResponse =
            VirtualNetworkFunctionNetworkFunctionDefinitionVersionResponse(
                deployParameters = javaType.deployParameters().map({ args0 -> args0 }).orElse(null),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                networkFunctionTemplate = javaType.networkFunctionTemplate().map({ args0 ->
                    args0.transform(
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.hybridnetwork.kotlin.outputs.AzureCoreNetworkFunctionTemplateResponse.Companion.toKotlin(args0)
                            })
                        },
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.hybridnetwork.kotlin.outputs.AzureOperatorNexusNetworkFunctionTemplateResponse.Companion.toKotlin(args0)
                            })
                        },
                    )
                }).orElse(null),
                networkFunctionType = javaType.networkFunctionType(),
                provisioningState = javaType.provisioningState(),
                versionState = javaType.versionState(),
            )
    }
}
